import {ICoordinates} from './common';

export interface ITransportStation {
    /**
     * id станции "station__9765108"
     */
    id: string;

    /**
     * тип станции, Метро или Другое.
     */
    type: ETransportStationType;

    /**
     * Название: "Площадь 1905г"
     */
    name: string;

    /**
     * Расположение
     */
    coordinates: ICoordinates;

    /**
     * Расстояние в метрах, "1114.87"
     */
    distanceMeters: number;

    /**
     * Человеко-читаемое расстояние, "1,1 км"
     */
    distanceText: string;

    /**
     * Если метро - то информация о линии.
     */
    metroLine?: IMetroLine;
}

export interface IMetroLine {
    /**
     * id линии "100000267"
     */
    id: string;
    /**
     * Название: "Арбат-Покровская"
     */
    name: string;
    /**
     * Цвет линии.
     */
    color?: string;
}

export enum ETransportStationType {
    METRO = 'METRO',
    OTHER = 'OTHER',
}

export interface IHotelGeoFeature {
    /**
     * Уникальный id геофичи
     */
    id: string;

    /**
     * Идентификатор иконки для отрисовки
     */
    icon: string;

    /**
     * Строковое представление геофичи (например, "1км от центра" или "Рядом аэропорт")
     */
    name: string;
}
