export interface IHotelImageNavigationParams {
    /** Лимит на размер выдачи. */
    imageLimit?: number;
    /** Смещение выдачи (сколько элементов с начала списка пропустить). */
    imageOffset?: number;
}

export interface IWithHotelImages {
    /** Общее количество фотографий.
     * Отсутствует для похожих отелей.
     */
    totalImageCount?: number;
    /** Фотографии.
     * Количество переданных фотографий зависит от контекста использования IHotel.
     * К примеру, для страницы отеля сразу будет указано несколько фотографий.
     * Для карты, для списка -- одна фотография. */
    images: IHotelImage[];
}

// взято из hotels/hotel-page-flow/getHotelImages/common.ts
export interface IHotelImage {
    /** Строка с URL картинки, подставляем нужный размер сами.
     * Пример:
     * https://avatars.mds.yandex.net/get-travel-rooms/3595101/2a000001733c3879e959006e979255e93538/%s
     * Вместо %s нужно подставить идентификатор размера (поле size) из списка sizes.
     * */
    urlTemplate: string;

    /** Идентификатор изображения.
     * Отсутствует для похожих отелей.
     */
    id?: string;

    /** Информация о разных размерах изображения (бывают XXXS | XXS | XS | S | M | L | XL | XXL | XXXL | orig).
     * Отсутствует для похожих отелей.
     */
    sizes?: {size: string; width: number; height: number}[];

    /** Произвольный набор тегов.
     * Отсутствует для похожих отелей.
     */
    tags?: string[];

    /** Информация о модерации изображения
     * Приходит для фотографий в отзывах
     */
    moderation?: IHotelImageModeration | null;
}

enum EHotelImageModerationStatus {
    IN_PROGRESS = 'IN_PROGRESS',
    ACCEPTED = 'ACCEPTED',
    DECLINED = 'DECLINED',
}

export interface IHotelImageModeration {
    status: EHotelImageModerationStatus;
}
