import {TLocalDate, TInstantDateTime, IPrice, TAmount} from './common';

/**
 * Параметры поиска отелей.
 */
export interface IBookingParams {
    /**
     * Количество взрослых.
     */
    adults: number;
    /**
     * Возраста детей.
     */
    childrenAges: number[];
    /**
     * Дата заезда.
     */
    checkinDate: TLocalDate;
    /**
     * Дата выезда.
     */
    checkoutDate: TLocalDate;
}

/**
 * Данные по бронированиям отелей.
 */
export interface IHotelOffers {
    /**
     * Идентификатор отеля.
     */
    hotelId: number;
    /**
     * Закончился ли поиск предложений конкретно в этом отеле.
     * Если true, то есть поле offers.
     * Если false, то поля offers еще нет.
     */
    searchIsFinished: boolean;

    /**
     * Вариант бронирования указанный по умолчанию.
     */
    defaultOffer?: IHotelOffer;

    /**
     * Список вариантов бронирования.
     */
    offers?: IHotelOffer[];
}

/** Предложение отеля */
export interface IHotelOffer {
    /**
     * Токен предложения бронирования
     */
    offerToken: string;
    /**
     * Наименование предложения
     * @example "Стандартный номер с 1 кроватью или 2 креслами"
     */
    name: string;
    /**
     * Стоимость данного предложения, вместе с данными о возможной скидке.
     */
    price: IPrice;

    /**
     * Идентификатор комнаты
     */
    roomId: string;

    /**
     * Политика отмены
     */
    cancellationInfo?: ICancellationInfo;
    /**
     * Тип питания
     */
    mealType?: IHotelOfferMeal;
}

export interface ICancellationInfo {
    /**
     * Бесплатная отмена (есть/нет).
     */
    hasFreeCancellation: boolean;
    /**
     * Отменяемость на текущий момент
     */
    refundType: ERefundType;
    /**
     * Подробные политики отмены.
     * - Если есть, то рисуется иконка с вопросиком, и в тултипе выводится подробная информация о штрафах.
     * - Есть нет, то ничего не рисуется
     */
    refundRules?: IRefundRule[];
}

export enum ERefundType {
    FULLY_REFUNDABLE = 'FULLY_REFUNDABLE',
    REFUNDABLE_WITH_PENALTY = 'REFUNDABLE_WITH_PENALTY',
    NON_REFUNDABLE = 'NON_REFUNDABLE',
}

export interface IRefundRule {
    startsAt: TInstantDateTime;
    endsAt: TInstantDateTime;
    type: ERefundType;
    penalty?: TAmount;
}

export type TOfferMeal =
    | 'AI'
    | 'UAI'
    | 'LAI'
    | 'BB'
    | 'FB'
    | 'HB'
    | 'RO'
    | 'BD'
    | 'UNKNOWN'; // Id типа питания

export interface IHotelOfferMeal {
    /**
     * Идентификатор типа питания. Используется для отрисовки иконки
     */
    id: TOfferMeal;
    /**
     * Наименование типа питания
     * @example Завтрак
     * @example Ужин
     */
    name: string;
}
