import {TInstantDateTime} from './common';
import {IHotelImage} from './hotel-images';

export interface ITextReview {
    /** Идентификатор отзыва. */
    id: string;
    /** Полный текст отзыва.
     * @example Пример: "Хороший отель, все понравилось." */
    text: string;
    /** Время последнего обновления. */
    updatedAt: TInstantDateTime;

    /** Автор отзыва. */
    author?: ITextReviewAuthor;
    /** Рейтинг отзыва. Целочисленный от 1 до 5.
     * Он же -- "Сколько звездочек в отзыве? */
    rating: number;
    /** Общее число лайков. */
    totalLikeCount: number;
    /** Общее число дизлайков. */
    totalDislikeCount: number;
    /** Количество комментариев для отзыва */
    commentCount: number;
    /** Фотографии, прикрепленные к отзыву */
    images: IHotelImage[];

    /** Краткое превью текста отзыва */
    snippet: string;
}

export interface ITextReviewAuthor {
    /** Имя или никнейм автора.
     * @example "Ксения С." */
    name: string;
    /** Уровень.
     * @example "Знаток города 15 уровня" */
    level: string;
    /** Ссылка на аватарку, если есть. */
    avatarUrl?: string;
    /** Ссылка на профиль пользователя. */
    profileUrl: string;
}

export interface IReviewsInfo {
    /**
     * Лимит на размер выдачи.
     */
    textReviewLimit: number;

    /**
     * Смещение выдачи (сколько элементов с начала списка пропущено).
     * textReviewOffset должен делиться на textReviewLimit без остатка.
     */
    textReviewOffset: number;

    /**
     * Способ сортировки отзывов.
     */
    textReviewRanking: ETextReviewRankingType;

    /**
     * Общее число текстовых отзывов.
     */
    totalTextReviewCount: number;

    /**
     * Текстовые отзывы на данной странице.
     * если textReviewOffset >= totalTextReviewCount тогда список пустой.
     */
    textReviews: ITextReview[];
}

export interface IHotelReviewsParams {
    /** Лимит на размер выдачи. */
    textReviewLimit?: number;
    /** Смещение выдачи (сколько элементов с начала списка пропустить).
     * textReviewOffset должен делиться на textReviewLimit без остатка. */
    textReviewOffset?: number;
    /** Способ сортировки отзывов. */
    textReviewRanking?: ETextReviewRankingType;

    /** Включить использование тестового инстанса UGC в АПИ. Работает только в тестинге */
    enabledTestUgc?: boolean;
}

// взято из hotels/common/common.ts
/** Типы сортировки отзывов */
export enum ETextReviewRankingType {
    TIME = 'byTime', // По времени
    RELEVANCE_ORG = 'byRelevanceOrg', // По релевантности ("интересные" отзывы в топе)
    LIKES_COUNT_DESC = 'byLikesCountDesc', // По убыванию количества положительных лайков
    RATING_ASC = 'byRatingAsc', // По возрастанию рейтинга (от плохого к хорошему)
    RATING_DESC = 'byRatingDesc', // По убыванию рейтинга (от хорошего к плохому)
}
