import {IPrice, ICoordinates} from './common';
import {IWithHotelImages} from './hotel-images';
import {IHotelAmenity, IHotelAmenitiesGroup} from './hotel-amenities';
import {IHotelGeoFeature, ITransportStation} from './hotel-geo';
import {IHotelOffer} from './hotel-offers';

export interface IHotelIdentifier {
    /**
     * Идентификатор Отеля
     */
    hotelId?: number;
    /**
     * Главный slug отеля. Может отсутствовать.
     */
    hotelSlug?: string;
}

export interface IHotelRoomIdentifier {
    /**
     * Идентификатор Отеля
     */
    hotelId?: number;
    /**
     * Главный slug отеля. Может отсутствовать.
     */
    hotelSlug?: string;
    /**
     * Идентификатор комнаты.
     */
    hotelRoomId: number;
}

export interface IHotelInfo extends IHotel {
    /**
     * Описание об отеле.
     */
    description: string;

    /**
     * "Что есть в отеле"
     */
    aboutHotel: IHotelAbout[];

    /**
     * Группы удобств
     */
    amenityGroups?: IHotelAmenitiesGroup[];

    /**
     * Комнаты в отеле
     */
    rooms: IHotelRoom[];
}

export interface IHotel extends IWithHotelImages {
    /** Идентификатор Отеля */
    hotelId: number;
    /** Главный slug отеля. Может отсутствовать. */
    hotelSlug?: string;

    /**
     * Наименование отеля.
     * @example "Артист"
     */
    name: string;

    /** Координаты отеля */
    coordinates: ICoordinates;

    /**
     * Количество звезд. От 1 до 5. Целое число.
     * Может отсутствовать, не у всех отелей есть звёзды.
     * @example 2
     */
    stars?: number;

    /**
     * Базовая стоимость ночи в отеле, с возможной скидкой.
     */
    basePriceByNight: IPrice;

    /**
     * Рейтинг. От 1 до 5. Дробное число, 1 знак после запятой.
     * Может отсутствовать, не у всех отелей есть рейтинг.
     * @example 3.4
     */
    yandexMapRating?: number;

    /**
     * Общее число отзывов.
     *
     * IMHO с 4.7 на 300 отзывах гораздо лучше, чем 5.0 на 3 отзывах.
     */
    yandexMapReviewCount?: number;

    /**
     * Информация о ближайших остановках транспорта
     */
    nearestStations?: ITransportStation[];

    /**
     * Геофича отеля
     */
    geoFeature?: IHotelGeoFeature | null;

    /**
     * фишки отеля.
     */
    mainHotelAmenities?: IHotelAmenity[];
}

export interface IHotelWithDefaultOffer extends IHotel {
    /**
     * Закончился ли поиск предложений конкретно в этом отеле.
     * Если true, то есть поле offers.
     * Если false, то поля offers еще нет.
     */
    searchIsFinished: boolean;

    /**
     * Вариант бронирования указанный по умолчанию.
     */
    defaultOffer?: IHotelOffer;
}

export interface IHotelRoom extends IWithHotelImages {
    /**
     * Id, машино-читаемая строка.
     */
    id: string;

    /**
     * Название комнаты.
     */
    name: string;

    /**
     * Площадь комнаты.
     */
    area: number;

    /**
     * Иконка кроватей.
     */
    bedIconCode: string;

    /**
     * Описание кроватей.
     */
    bedDescription: string;

    /**
     * фишки отеля.
     */
    mainHotelAmenities?: IHotelAmenity[];

    /**
     * Группы удобств.
     */
    amenityGroups?: IHotelAmenitiesGroup[];
}

export interface IHotelAbout {
    /**
     * Описание свойства отеля.
     */
    description: string;

    /**
     * иконки соответсвующее описанию.
     */
    iconCodes: string[];
}
