import {TAmount} from './common';

export type TSortId = string;

export interface IHotelSortParams {
    // Id выбранного типа сортировки
    selectedSortId?: TSortId;

    // Центр сортировки (например для сортировки по расстоянию). Нужен не для всех сортировок.
    // lon,lat (например 37.0408809,55.311850)
    sortOrigin?: string;

    /**
     * Показать первым в списке отель с этим слагом.
     */
    topHotelSlug?: string;
}

export interface IHotelFilterParams {
    /**
     *  Окно карты (при последующих запросах).
     *  bbox=37.0408809,55.311850~38.20412732,56.18961995; // lon,lat~lon,lat
     */
    bbox?: string;

    /**
     * Отбираем только отели с выбранными свойствами.
     */
    amenityFilterIds: string[];

    /**
     * Отбираем только отели с выбранными расположением.
     * Значения в формате {IHotelGeoFeatureFilter.id}:{IHotelGeoFeatureFilterOption.id}.
     */
    geoFeatureFilters: string[];
}

export interface IHotelPageNavigationParams {
    /**
     * Сколько отелей отображать в списке.
     * Нужно для корректного формирования навигационных токенов.
     */
    pageHotelLimit: number;

    /**
     * Смещение для запроса отелей.
     */
    pageHotelOffset: number;
}

export interface IHotelPriceFilterParams {
    /**
     * Минимальная цена предложения.
     */
    filterPriceFrom?: TAmount;
    /**
     * Максимальная цена предложения.
     */
    filterPriceTo?: TAmount;
}
