export enum EBindingCreationStatus {
    ORDER_NOT_FOUND, // Такого заказа нет. Либо ошибка в номере/датах, либо заказ сделан несколько минут назад и ещё не получен нами
    ALREADY_BOUND_TO_CURRENT_USER, // Заказ уже привязан к текущему пользователю
    ALREADY_BOUND_TO_OTHER_USER, // Заказ уже привязан к какому-то другому пользователю
    NO_LABEL, // Заказ сделан не после перехода с яндекс путешествий (aka прямой заход)
    NON_PLUS_ON_PURCHASE, // Заказ уже привязан к пользователю, но пользователь не был плюсовиком в момент заказа
    ORDER_IS_TOO_OLD, // Заказ слишком старый
    CREATED, // Привязка создана
}

export interface IResponse {
    // Статус запроса постпривязки
    creationStatus?: EBindingCreationStatus;

    // Дата планируемого начисления. Присутствует если creationStatus равен ALREADY_BOUND_TO_CURRENT_USER или CREATED
    expectedTopupDate?: string;
}
