import {IAffiliateAttribution} from 'common/IAffiliateAttribution';

export enum EDirection {
    FORWARD = 'FORWARD',
    BACKWARD = 'BACKWARD',
}

export enum EGender {
    MIXED = 'mixed',
    MALE = 'male',
    FEMALE = 'female',
    SINGLE = 'single',
}

export enum ETrainsCoachType {
    PLATZKARTE = 'platzkarte',
    COMPARTMENT = 'compartment',
    SUITE = 'suite',
    COMMON = 'common',
    SITTING = 'sitting',
    SOFT = 'soft',
}

export enum ERoutePolicy {
    INTERNAL = 'internal',
}

enum ETrainsDocumentType {
    RUSSIAN_PASSPORT = 'ПН',
    BIRTH_CERTIFICATE = 'СР',
    RUSSIAN_INTERNATIONAL_PASSPORT = 'ЗП',
    FOREIGN_DOCUMENT = 'ЗЗ',
    SAILOR_PASSPORT = 'ПМ',
    MILITARY_CARD = 'ВБ',
}

enum EPassengerType {
    ADULTS = 'adults',
    CHILDREN = 'children',
    BABIES = 'babies',
}

enum ETrainBonusCard {
    ROAD_CARD = 'RzhdU',
    BONUS_CARD = 'RzhdB',
}

interface ITrainsCreateOrderLoyaltyCard {
    /**
     * Тип бонусной карты.
     */
    type: ETrainBonusCard;

    /**
     * Номер бонусной карты.
     */
    number: string;
}

export interface ITrainsSaveOfferPassenger {
    /**
     * Индекс пассажира
     */
    index: number;
    /**
     * Пол пассажира.
     */
    sex: 'M' | 'F';
    /**
     * Тип документа.
     */
    doc_type: ETrainsDocumentType;
    /**
     * GeoId страны, гражданство которой имеет пассажир.
     */
    citizenship_geo_id: number;
    /**
     * Тарифная группа.
     * Например, «full», «child», «child_17», «pupil», «baby».
     */
    tariff: string;
    /**
     * Был выбран невозвратный тариф
     */
    is_non_refundable_tariff: boolean;
    /**
     * Возрастная группа.
     */
    age_group: EPassengerType;
    /**
     * Места для пассажира.
     */
    places: number[];
    /**
     * Бонусные карты.
     */
    loyalty_cards: ITrainsCreateOrderLoyaltyCard[];
}

export enum EArrangementRequirements {
    COMPARTMENT = 'compartment',
    NEAREST = 'nearest',
    SECTION = 'section',
    NOT_SIDE = 'notSide',
    IRRELEVANT = 'irrelevant',
}

interface ISittingCountRequirements {
    nearWindow: number;
    nearPassage: number;
}

export interface ICompartmentCountRequirements {
    upper: number;
    bottom: number;
}

export type TCountRequirements =
    | ISittingCountRequirements
    | ICompartmentCountRequirements;

export interface ITrainsCreateOrderRequirements {
    arrangement?: EArrangementRequirements;
    number?: number;
    count?: TCountRequirements;
}

export enum EAdditionalRequirements {
    FORWARD = 'Forward',
    NEAR_WINDOW = 'NearWindow',
    NEAR_TABLE_AND_FORWARD = 'NearTheTableAndForward',
    NEAR_TABLE = 'AnyNearTheTable',
    NO_TABLE = 'AnyNotNearTheTable',
    NO_TABLE_AND_FORWARD = 'WithoutTableAndForward',
    SINGLE_AND_FORWARD = 'SingleAndForward',
    WITH_PETS = 'WithPetsPlaces',

    // Не используется фронтендом
    NO_VALUE = 'NoValue',
    MOTHER_AND_BABY_PLACES = 'MotherAndBabyPlaces',
    WITH_BABY_PLACES = 'WithBabyPlaces',
    USUAL = 'Usual',
    USUAL_NEAR_THE_TABLE = 'UsualNearTheTable',
    NEAR_THE_PLAYGROUND = 'NearThePlayground',
    NEAR_THE_PLAYGROUND_AND_NOT_THE_TABLE = 'NearThePlaygroundAndNotTheTable',
    NEAR_THE_PLAYGROUND_AND_THE_TABLE = 'NearThePlaygroundAndTheTable',
    NEAR_THE_PLACES_WITH_PETS = 'NearThePlacesWithPets',
    FOLDABLE_PLACE = 'FoldablePlace',
    BACKWARD = 'Backward',
    UNFOLDABLE_PLACE = 'UnfoldablePlace',
    NEAR_THE_TABLE_AND_BACKWARD = 'NearTheTableAndBackward',
    WITHOUT_TABLE_AND_BACKWARD = 'WithoutTableAndBackward',
    WITHOUT_WINDOW_AND_BACKWARD = 'WithoutWindowAndBackward',
    WITHOUT_WINDOW_AND_FORWARD = 'WithoutWindowAndForward',
    NEAR_RESTROOM = 'NearRestroom',
    NEAR_RESTROOM_AND_BACKWARD = 'NearRestroomAndBackward',
    NEAR_RESTROOM_AND_FORWARD = 'NearRestroomAndForward',
    NO_TABLE_AND_NO_WINDOW = 'NoTableAndNoWindow',
}

/**
 * Метаинформация для создания оффера OfferRequestLabelParams
 * https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/train_offer_storage/internal/api/models/store_offer_request.go#L66
 */
export interface ITrainsSource extends IAffiliateAttribution {
    req_id?: string;
    utm_source?: string;
    utm_medium?: string;
    utm_campaign?: string;
    utm_term?: string;
    utm_content?: string;
    from?: string;
    gclid?: string;
    yclid?: string;
    fbclid?: string;
    icookie?: string;
    serp_uuid?: string;
    yandex_uid?: string;
    uid?: string;
    test_buckets?: string;
    partner?: string;
    sub_partner?: string;
    partner_uid?: string;
    device: string;
    terminal: string;
    is_transfer: boolean;
    ip?: string;
    region_id?: number;
    wizard_req_id?: string;
    serp_test_id?: string;
    ytp_referer?: string;
    metrika_client_id?: string;
}
