import EActivePartners from 'trains/common/EActivePartners';

import {
    EGender,
    EDirection,
    ERoutePolicy,
    ITrainsSource,
    ETrainsCoachType,
    EAdditionalRequirements,
    ITrainsSaveOfferPassenger,
    ITrainsCreateOrderRequirements,
} from './models';

/**
 * @type POST
 * @url https://production.offer-storage.internal.rasp.yandex.net/store
 */
export interface IRequestBody {
    /**
     * Направление поезда для сложного заказа
     */
    direction: EDirection;

    /**
     * Индекс поезда в пересадках для сложного заказа
     */
    segment_index: number;

    /**
     * Номер поезда из вагона.
     * Может отличаться для бесапересадочных вагонов.
     */
    train_number: string;
    /**
     * Номер поезда из сегмента.
     */
    train_ticket_number: string;
    /**
     * Например, «Москва — Санкт-Петербург».
     */
    train_title: string;
    /**
     * Например, «Малахит» или «Сапсан.
     */
    brand_title?: string;
    /**
     * Название перевозчика
     */
    company_title?: string;
    /**
     * Поле rawTrainName из trainDetails
     */
    raw_train_name: string;

    /**
     * Express ID странции отправления.
     */
    station_from_id: number;
    /**
     * Express ID странции прибытия.
     */
    station_to_id: number;
    /**
     * Время отправления в ISO DateTime с таймзоной.
     */
    departure: string;
    /**
     * Время прибытия в ISO DateTime с таймзоной.
     */
    arrival: string;

    /**
     * Пол выбранных мест в купе.
     */
    cabin_gender_kind?: EGender;
    /**
     * Номер вагона.
     * Отсутствует, если есть поле requirements.
     */
    car_number?: string;
    /**
     * Тип вагона.
     */
    car_type: ETrainsCoachType;
    /**
     * Код сервисного класса.
     * Например, «3Л» или «2У».
     */
    service_class: string;
    /**
     * Есть ли электронная регистрация для данного вагона.
     * Не поддерживается на данный момент
     */
    international_service_class?: string;
    route_policy: ERoutePolicy;

    is_cppk: boolean;
    scheme_id?: number | null;
    electronic_registration: boolean;
    /**
     * Есть ли возможность включать постельное белье в заказ.
     */
    can_choose_bedding: boolean;
    /**
     * Включено ли постельное белье в заказ.
     */
    bedding: boolean;
    /**
     * Возможность купить место для ребенка от 5 до 10 лет бесплатно.
     * Не поддерживается на данный момент
     */
    give_child_without_place?: boolean;

    /**
     * Данные пассажиров.
     */
    passengers: ITrainsSaveOfferPassenger[];
    /**
     * Места в вагоне.
     */
    places: number[];

    /**
     * Требования к местам.
     */
    requirements?: ITrainsCreateOrderRequirements;
    /**
     * Дополнительное требование к местам.
     * Например, сиденья по направлению движения.
     */
    additional_place_requirements?: EAdditionalRequirements;

    /**
     * Партнер
     */
    partner: EActivePartners;

    /**
     * Информация откуда пришел пользователь.
     */
    label_params: ITrainsSource;

    /**
     * Начальная станция, с которой отправляется поезд. От партнера.
     */
    im_initial_station_name: string;
    /**
     * Конечная станция, на которую прибывает поезд. От партнера.
     */
    im_final_station_name: string;

    /**
     * Итоговая сумма в рублях
     */
    amount: number;

    /**
     * Поставщик услуг "Экспресс", "Мовиста" от ИМ
     */
    provider: string;

    /**
     * Динамическая наценка
     */
    fee_calculation_token: string;

    /**
     * Параметры которые проставляются на беке в TrainsService
     */
    wizard_req_id?: string;
    serp_test_id?: string;
    metrikaClientId?: string;
}
