import {IPrice} from '../../common/common';
import ECoachType from './ECoachType';
import {IPlacesDetails} from './IPlacesDetails';

export default interface IMinTariffClass {
    /**
     * Тип вагона
     */
    type: ECoachType;

    /**
     * Минмальная цена для текущего типа вагона
     */
    price: IPrice;

    /**
     * Количество мест для текущего типа вагона
     */
    seats: number;

    /**
     * Есть ли в вагоне места с невозвратным тарифом
     */
    hasNonRefundableTariff: boolean;

    /**
     * Детализация по местам для ховера
     */
    placesDetails?: IPlacesDetails;
}
