import IStation from './IStation';
import ITrain from './ITrain';
import ICompany from './ICompany';
import TFeature from './features/TFeature';
import {IMinTariffs} from './IMinTariffs';
import EFeatureType from './features/EFeatureType';

export type TSegmentId = string;

export default interface ISegment {
    /**
     * Уникальный идентификатор сегмента
     */
    id: TSegmentId;
    /**
     * Время отправления поезда в UTC
     * Часовой пояс указан в станции отправления stationFrom
     */
    departure: string;
    /**
     * Время прибытия поезда в UTC
     * Часовой пояс указан в станции прибытия stationTo
     */
    arrival: string;

    /**
     * Станция отправления поезда
     */
    stationFrom: IStation;
    /**
     * Станция прибытия поезда
     */
    stationTo: IStation;
    /**
     * Перевозчик
     */
    company?: ICompany;
    /**
     * Время в пути
     */
    duration: number;

    /**
     * Поезд
     */
    train: ITrain;

    /**
     * Особенности поезда
     */
    features: Partial<Record<EFeatureType, TFeature>>;

    /**
     * Поставщик услуг
     */
    provider?: string;

    /**
     * Минимальные цены
     */
    tariffs: IMinTariffs;
}
