import ISegment from './ISegment';
import TVariantUrl from './TVariantUrl';

/**
 * Вариант поездки на поезде:
 * туда или туда-обратно
 * прямой маршрут или с пересадками
 */
export default interface IVariant {
    /**
     * Уникальный идентификатор варианта
     */
    id: string;

    /**
     * Маршрут туда
     * forward.length > 1 маршрут с пересадками, иначе прямой маршрут
     */
    forward: ISegment[];
    /**
     * Маршрут обратно
     */
    backward: ISegment[];

    /**
     * Ссылка перехода на покупку
     * Отсутствует у вариантов без цен
     */
    orderUrl?: TVariantUrl;
}
