import EUrlOwner from '../search/search/models/EUrlOwner';

/**
 * Внешняя покупка у партнера
 */
interface IExternalUrl {
    owner: EUrlOwner.UFS;

    /**
     * Ссылка на покупку, приходит в ответе
     * например UFS https://www.ufs-online.ru/kupit-zhd-bilety/${stationFrom.codes.express}/${stationTo.codes.express}?date=...&trainNumber=...&domain=yandex.ufs-online.ru
     */
    url: string;
}

/**
 * Покупка у нас в сервисе
 * Ссылку собираем на фронте по данным из IVariant по правилам из
 * https://st.yandex-team.ru/TRAVELFRONT-4559
 */
interface IInternalUrl {
    owner: EUrlOwner.TRAIN;
}

type TVariantUrl = IExternalUrl | IInternalUrl;

export default TVariantUrl;
