import EFeatureType from './EFeatureType';

type TFeature =
    | {
          type: EFeatureType.ETICKET | EFeatureType.DYNAMIC_PRICING;
      }
    | {
          type: EFeatureType.THROUGH_TRAIN;
          /**
           * У беспересадочного вагона могут быть вагоны с разным временем прибытия
           */
          arrival: {
              /**
               * Минимальное время прибытия в UTC
               */
              min: string;
              /**
               * Максимальное время прибытия в UTC
               */
              max: string;
          };
      }
    | {
          type: EFeatureType.NAMED_TRAIN;
          id: number;
          title: string;
          isDeluxe: boolean;
          isHighSpeed: boolean;
      }
    | {
          type: EFeatureType.SUBTYPE;
          id: number;
          /**
           * @default Экспресс
           */
          title?: string;
      };

export default TFeature;
