export interface ISearchContextPoint {
    key: string;
    title: string;
    titleWithType?: string;
    shortTitle?: string;
    titleGenitive?: string;
    titleLocative?: string;
    preposition?: string;
    popularTitle?: string;
    titleAccusative?: string;
}

export default interface ISearchContext {
    transportTypes: string[];
    search: {
        nearest: boolean;
        pointTo: ISearchContextPoint;
        pointFrom: ISearchContextPoint;
    };
    original: {
        nearest: boolean;
        pointTo: ISearchContextPoint;
        pointFrom: ISearchContextPoint;
    };
    latestDatetime: string;
    isChanged: boolean;
}
