import {IResponse} from '../response';
import {ESectionBlock} from '../../../../common/seo-pages/ISectionTextBlock';
import {ECurrencyType} from '../../../../common/common';
import {ETransportVertical} from '../../../../common/vertical';

const response200: IResponse = {
    searchDate: '2021-09-20',
    blocks: {
        header: {
            title: 'Купить билеты на поезд Москва — Санкт-Петербург',
            text: {
                type: ESectionBlock.TEXT_BLOCK,
                children: [
                    {
                        type: ESectionBlock.PLAIN_TEXT_BLOCK,
                        data: {
                            text: 'Выберите дату отправления, чтобы узнать расписание поездов, проверить наличие мест, сравнить стоимость ж/д билетов и купить их онлайн.',
                        },
                    },
                ],
            },
        },
        segments: {
            title: 'Расписание поездов из Москвы в Санкт-Петербург',
        },
        info: {
            title: 'Информация по маршруту поезда Москва — Санкт-Петербург',
            text: {
                type: ESectionBlock.TEXT_BLOCK,
                children: [
                    {
                        type: ESectionBlock.PLAIN_TEXT_BLOCK,
                        data: {
                            text: 'Отправление из Москвы — Ленинградский вокзал, Киевский вокзал, Восточный вокзал и Курский вокзал, прибытие в Санкт-Петербурге — Московский вокзал и Ладожский вокзал. Первый поезд отправляется в 00:20, последний — в 23:55 по местному времени. По маршруту проходит около 31 поезда в день, в том числе фирменные поезда «Мегаполис», «Смена/А.Бетанкур - двухэтажный состав», «Двухэтажный состав», «Экспресс», «Гранд-Экспресс», «Красная стрела», «Арктика» и скоростные поезда «Сапсан», «Ласточка», «Стриж».',
                        },
                    },
                ],
            },
            disclaimer: {
                type: ESectionBlock.TEXT_BLOCK,
                children: [
                    {
                        type: ESectionBlock.PLAIN_TEXT_BLOCK,
                        data: {
                            text: 'Данные могут отличаться в зависимости от даты поездки. Используйте форму поиска, чтобы проверить наличие мест и стоимость билета по маршруту Москва — Санкт-Петербург на выбранные даты.',
                        },
                    },
                ],
            },
        },
        faq: {
            items: [
                {
                    title: 'Сколько стоит билет на поезд Москва — Санкт-Петербург?',
                    text: {
                        type: ESectionBlock.TEXT_BLOCK,
                        children: [
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: 'Минимальная стоимость железнодорожного билета из Москвы в Санкт-Петербург — ',
                                },
                            },
                            {
                                type: ESectionBlock.PRICE_TEXT_BLOCK,
                                data: {
                                    price: {
                                        value: 756,
                                        currency: ECurrencyType.RUB,
                                    },
                                },
                            },
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: ' в сидячем вагоне, в купе — от ',
                                },
                            },
                            {
                                type: ESectionBlock.PRICE_TEXT_BLOCK,
                                data: {
                                    price: {
                                        value: 883,
                                        currency: ECurrencyType.RUB,
                                    },
                                },
                            },
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: ', в плацкарте — от ',
                                },
                            },
                            {
                                type: ESectionBlock.PRICE_TEXT_BLOCK,
                                data: {
                                    price: {
                                        value: 1003,
                                        currency: ECurrencyType.RUB,
                                    },
                                },
                            },
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: ', в СВ — от ',
                                },
                            },
                            {
                                type: ESectionBlock.PRICE_TEXT_BLOCK,
                                data: {
                                    price: {
                                        value: 2964,
                                        currency: ECurrencyType.RUB,
                                    },
                                },
                            },
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: '. Самый дорогой билет в вагон люкс: его цена начинается от ',
                                },
                            },
                            {
                                type: ESectionBlock.PRICE_TEXT_BLOCK,
                                data: {
                                    price: {
                                        value: 11490,
                                        currency: ECurrencyType.RUB,
                                    },
                                },
                            },
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: '.',
                                },
                            },
                        ],
                    },
                },
                {
                    title: 'Сколько ехать на поезде из Москвы до Санкт-Петербурга?',
                    text: {
                        type: ESectionBlock.TEXT_BLOCK,
                        children: [
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: 'Расстояние от Москвы до Санкт-Петербурга — 634 км. Минимальное время в пути составит 3 ч 45 мин, максимальное — 2 дн. 2 ч в зависимости от типа поезда и количества остановок. Посмотрите расписание всех поездов дальнего следования, чтобы подобрать оптимальный маршрут.',
                                },
                            },
                        ],
                    },
                },
                {
                    title: 'Как купить дешёвые билеты?',
                    text: {
                        type: ESectionBlock.TEXT_BLOCK,
                        children: [
                            {
                                type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                data: {
                                    text: 'Самый надёжный способ найти дешёвые ж/д-билеты из Москвы в Санкт-Петербург — заранее спланировать поездку. Билеты обычно появляются в продаже за 90 суток до даты отправления, затем цена начинает расти. РЖД часто предлагает верхние места в купе со скидкой 50%, цена на них может оказаться ниже плацкарта.',
                                },
                            },
                        ],
                    },
                },
            ],
        },
        transportRoutes: {
            title: 'Если не на поезде то как?',
            items: [
                {
                    transport: ETransportVertical.AVIA,
                    fromSlug: 'moscow',
                    toSlug: 'saint-petersburg',
                    text: 'Вжух на самолётике из Мск в Спб',
                    minPrice: {
                        value: '3246',
                        currency: ECurrencyType.RUR,
                    },
                },
                {
                    transport: ETransportVertical.BUSES,
                    fromSlug: 'moscow',
                    toSlug: 'saint-petersburg',
                    text: 'Бром бром! Поехали на автобусе из столицы в северную',
                },
            ],
        },
    },
    seoInfo: {
        title: 'Москва — Санкт-Петербург: билеты на поезд, расписание поездов — Яндекс.Путешествия',
        description:
            'Покупка билетов на поезд Москва — Санкт-Петербург онлайн. Цены на ж/д билеты и наличие мест. Москва — Санкт-Петербург: актуальное расписание поездов на 2021 год. На сервисе Яндекс.Путешествия можно построить маршруты на поездах; посмотреть расписание и купить ж/д билет.',
        openGraph: {
            title: 'Москва — Санкт-Петербург: билеты на поезд, расписание поездов — Яндекс.Путешествия',
            description:
                'Покупка билетов на поезд Москва — Санкт-Петербург онлайн. Цены на ж/д билеты и наличие мест. Москва — Санкт-Петербург: актуальное расписание поездов на 2021 год. На сервисе Яндекс.Путешествия можно построить маршруты на поездах; посмотреть расписание и купить ж/д билет.',
        },
        schemaOrg: {
            offerData: {
                name: 'Москва — Санкт-Петербург: билеты на поезд, расписание поездов — Яндекс.Путешествия',
                price: {
                    value: 953,
                    currency: ECurrencyType.RUB,
                },
            },
            faqItems: [
                {
                    question:
                        'Сколько стоит билет на поезд Москва — Санкт-Петербург?',
                    answer: 'Минимальная стоимость железнодорожного билета из Москвы в Санкт-Петербург — 756 рублей в сидячем вагоне, в купе — от 883 рублей, в плацкарте — от 1 003 рублей, в СВ — от 2 964 рублей. Самый дорогой билет в вагон люкс: его цена начинается от 11 490 рублей.',
                },
                {
                    question:
                        'Сколько ехать на поезде из Москвы до Санкт-Петербурга?',
                    answer: 'Расстояние от Москвы до Санкт-Петербурга — 634 км. Минимальное время в пути составит 3 ч 45 мин, максимальное — 2 дн. 2 ч в зависимости от типа поезда и количества остановок. Посмотрите расписание всех поездов дальнего следования, чтобы подобрать оптимальный маршрут.',
                },
                {
                    question: 'Как купить дешёвые билеты?',
                    answer: 'Самый надёжный способ найти дешёвые ж/д-билеты из Москвы в Санкт-Петербург — заранее спланировать поездку. Билеты обычно появляются в продаже за 90 суток до даты отправления, затем цена начинает расти. РЖД часто предлагает верхние места в купе со скидкой 50%, цена на них может оказаться ниже плацкарта.',
                },
            ],
        },
    },
};

export default response200;
