import {ISeoInfo} from 'common/seo-pages/ISeoInfo';
import {ICrossSaleHotelsBlock} from 'common/seo-pages/ICrossSaleHotelsBlock';
import {TTransportRoutesData} from 'common/seo-pages/ITransportRoutesBlock';

import {
    ITrainDirectionFAQBlock,
    ITrainDirectionHeaderBlock,
    ITrainDirectionInfoBlock,
    ITrainDirectionSegmentsBlock,
    ITrainDirectionSeoInfo,
} from './models';

export interface IResponse {
    /**
     * Дата, на которую нужно искать варианты. Обычно это дата, на которую есть прямые поезда,
     * но если прямых поездов нет, то возвращать дату на завтра,
     * чтобы можно было поискать пересадки.
     */
    searchDate: string;
    blocks: {
        header: ITrainDirectionHeaderBlock;
        segments?: ITrainDirectionSegmentsBlock;
        info?: ITrainDirectionInfoBlock;
        faq?: ITrainDirectionFAQBlock;
        /**
         * TODO: Долг команды органики.
         * Сейчас это поле не приходит, а данные запрашиваются отдельной ручкой. Нужно отказаться от ручки и эти данные добавить тут
         */
        transportRoutes?: TTransportRoutesData;
        hotels?: ICrossSaleHotelsBlock;
    };
    seoInfo: ISeoInfo<ITrainDirectionSeoInfo>;
}
