import {IResponse} from '../response';
import {ESectionBlock} from '../../../../common/seo-pages/ISectionTextBlock';
import {EFirmTrainAdvantageIcon, EFirmTrainBlock} from '../models';

const sapsanResponse200: IResponse = {
    seoInfo: {
        openGraph: {
            image: 'https://regnum.ru/uploads/pictures/news/2020/08/07/regnum_picture_1596832517256292_normal.jpg',
            imageSize: {
                width: 1815,
                height: 1212,
            },
            description: 'Описание',
            title: 'Сапсан',
        },
        schemaOrg: {
            faqItems: [
                {
                    question: 'Как купить дешевые билеты на «Сапсан»?',
                    answer: 'Для поездов «Сапсан» действует динамическое ценообразование. Это значит, что цена изменяется в зависимости от количества оставшихся свободных мест и спроса на них, поэтому советуем покупать билет как можно раньше.',
                },
                {
                    question:
                        'За сколько дней начинается продажа билетов на «Сапсан»?',
                    answer: 'Билеты на «Сапсан начинают продаваться за 90 дней до отправления поезда ровно в 8:00 по Московскому времени.',
                },
                {
                    question: 'Какая скорость у «Сапсана»?',
                    answer: 'Средняя скорость «Сапсана» 200 км/ч, но на некоторых участках он может разгоняться до 250 км/ч',
                },
                {
                    question: 'Есть ли в «Сапсане» Wi-Fi?',
                    answer: 'Во всех поездах «Сапсан» есть беспроводной интернет, но доступ к нему зависит от класса вагона, в котором вы приобрели билет. Пассажирам первого класса безлимитный интернет доступен бесплатно. Для пассажиров бизнес-класа действуют ограничения на объем трафика. В вагоне класса эконом за интернет потребуется заплатить отдельно, это можно сделать, обратившись к проводнику-кассиру.',
                },
                {
                    question: 'Какие места лучше брать в «Сапсане»?',
                    answer: 'Обращайте внимание на направление движения поезда. Обычно пассажирам комфортнее ехать по ходу движения. Так же обратите внимание на наличие розеток. В вагонах класса эконом они есть только у мест 3 и 4, в других классах розетки доступны всем пассажирам.',
                },
            ],
        },
        description: 'Описание',
        title: 'Сапсан',
    },
    blocks: [
        {
            type: EFirmTrainBlock.SEARCH_FORM,
            data: {
                title: 'Билеты на Сапсан',
                imageUrl:
                    'https://regnum.ru/uploads/pictures/news/2020/08/07/regnum_picture_1596832517256292_normal.jpg',
            },
        },
        {
            type: EFirmTrainBlock.DESCRIPTION,
            data: {
                title: 'Высокоскоростной поезд «Сапсан» — ',
                text: {
                    type: ESectionBlock.TEXT_BLOCK,
                    children: [
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: 'это самый быстрый и комфортный способ путешествовать между Москвой, Санкт-Петербургом и Нижним Новгородом. Часто поездка на нём оказывается короче перелёта с учётом времени на дорогу в аэропорт, регистрацию на рейс, ожидание взлёта и',
                            },
                        },
                        {
                            type: ESectionBlock.EXTERNAL_LINK_BLOCK,
                            data: {
                                text: 'дорогу из аэропорта в город',
                                url: 'https://some-site.com',
                            },
                        },
                        {
                            type: ESectionBlock.PLAIN_TEXT_BLOCK,
                            data: {
                                text: '.',
                            },
                        },
                    ],
                },
            },
        },
        {
            type: EFirmTrainBlock.ADVANTAGES,
            data: {
                items: [
                    {
                        title: 'Маленькое время в пути',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Средняя скорость Сапсана 200 км/ч и на его пути мало остановок — часто это сочетание позволяет добираться из центра одного города в центр другого быстрее, чем с использованием самолёта.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.TIME,
                    },
                    {
                        title: 'Современный состав',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Вагоны оборудованы розетками для зарядки устройств, кондиционерами и современными туалетами. Есть Wi-Fi, гардероб и специальные места для крупного багажа.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.STARS,
                    },
                    {
                        title: 'Можно с животными',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'В каждом поезде есть вагоны со специальными местами для проезда с животными весом до 10 кг. Покупать дополнительный билет или оформлять какое-то специальное разрешение не нужно.',
                                    },
                                },
                            ],
                        },
                        iconType: EFirmTrainAdvantageIcon.ANIMALS,
                    },
                ],
            },
        },
        {
            type: EFirmTrainBlock.FAQ,
            data: {
                title: 'Частые вопросы о поезде «Сапсан»',
                items: [
                    {
                        title: 'Как купить дешевые билеты на «Сапсан»?',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Для поездов «Сапсан» действует динамическое ценообразование. Это значит, что цена изменяется в зависимости от количества оставшихся свободных мест и спроса на них, поэтому советуем покупать билет как можно раньше.',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'За сколько дней начинается продажа билетов на «Сапсан»?',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Билеты на «Сапсан начинают продаваться за 90 дней до отправления поезда ровно в 8:00 по Московскому времени.',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'Какая скорость у «Сапсана»?',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Средняя скорость «Сапсана» 200 км/ч, но на некоторых участках он может разгоняться до 250 км/ч',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'Есть ли в «Сапсане» Wi-Fi?',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Во всех поездах «Сапсан» есть беспроводной интернет, но доступ к нему зависит от класса вагона, в котором вы приобрели билет. Пассажирам первого класса безлимитный интернет доступен бесплатно. Для пассажиров бизнес-класа действуют ограничения на объем трафика. В вагоне класса эконом за интернет потребуется заплатить отдельно, это можно сделать, обратившись к проводнику-кассиру.',
                                    },
                                },
                            ],
                        },
                    },
                    {
                        title: 'Какие места лучше брать в «Сапсане»?',
                        text: {
                            type: ESectionBlock.TEXT_BLOCK,
                            children: [
                                {
                                    type: ESectionBlock.PLAIN_TEXT_BLOCK,
                                    data: {
                                        text: 'Обращайте внимание на направление движения поезда. Обычно пассажирам комфортнее ехать по ходу движения. Так же обратите внимание на наличие розеток. В вагонах класса эконом они есть только у мест 3 и 4, в других классах розетки доступны всем пассажирам.',
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
};

export default sapsanResponse200;
