import {ITextBlock} from '../../../common/seo-pages/ISectionTextBlock';

export enum EFirmTrain {
    SAPSAN = 'sapsan',
}

export enum EFirmTrainBlock {
    SEARCH_FORM = 'SEARCH_FORM',
    DESCRIPTION = 'DESCRIPTION',
    ADVANTAGES = 'ADVANTAGES',
    FAQ = 'ADVANTAGES',
}

export enum EFirmTrainAdvantageIcon {
    TIME = 'TIME',
    STARS = 'STARS',
    ANIMALS = 'ANIMALS',
}

interface IFirmTrainSearchFormBlock {
    type: EFirmTrainBlock.SEARCH_FORM;
    data: {
        title: string;
        imageUrl: string;
    };
}

interface IFirmTrainDescriptionBlock {
    type: EFirmTrainBlock.DESCRIPTION;
    data: {
        title: string;
        text: ITextBlock;
    };
}

interface IFirmTrainAdvantageItem {
    title: string;
    text: ITextBlock;
    iconType: EFirmTrainAdvantageIcon;
}

interface IFirmTrainAdvantagesBlock {
    type: EFirmTrainBlock.ADVANTAGES;
    data: {
        items: IFirmTrainAdvantageItem[];
    };
}

interface IFirmTrainFaqItem {
    title: string;
    text: ITextBlock;
}

interface IFirmTrainFaqBlock {
    type: EFirmTrainBlock.FAQ;
    data: {
        title: string;
        items: IFirmTrainFaqItem[];
    };
}

export type TFirmTrainBlock =
    | IFirmTrainSearchFormBlock
    | IFirmTrainDescriptionBlock
    | IFirmTrainAdvantagesBlock
    | IFirmTrainFaqBlock;
