export interface ITransformSearchContextRequestParams {
    /**
     * Идентификация пункта отправления по pointKey из расписаний или geoId из отелей
     */
    fromPointKey?: string;
    fromGeoId?: number;

    /**
     * Идентификация пункта прибытия по pointKey из расписаний или geoId из отелей
     */
    toPointKey?: string;
    toGeoId?: number;

    /**
     * Даты отправления/прибытия в стандартном формате YYYY-MM-DD
     */
    dateForward?: string;
    dateBackward?: string;

    /**
     * Для какой вертикали хотим получить контекст
     */
    vertical: 'avia' | 'trains' | 'hotels' | 'buses';
}
