import {ILinguistics, IPrice} from '../../common/common';
import {TGeoRegionSlug} from '../../hotels/common/common';

export interface IRecipeBlock {
    directions: IDirection[];
}

export interface ICrossLinkBlock extends IRecipeBlock {
    title: string;
}

export interface IDirection {
    from?: IDirectionDestination; // Не заполняется для отелей
    to: IDirectionDestination;
    minPrice?: IPrice;
    imageUrl: string;
}

export interface IDirectionDestination {
    slug: TGeoRegionSlug;
    linguistics: Pick<
        ILinguistics,
        'nominativeCase' | 'genitiveCase' | 'accusativeCase'
    >;
}
