import {
    TDate,
    TInstantDateTime,
    IPrice,
    EGender,
    ICoordinates,
} from '../../../common/common';
import {ILegalEntity} from '../../../common/legal_entity';
import EDocumentType from '../../../common/EDocumentType';
import {IRefundPartInfo} from '../generic-booking-flow/common';

export interface IBusServiceInfo {
    partnerOrderId?: string;
    ride: IBusRide;
    tickets: IBusTicket[];
    downloadBlankToken?: string;
}

export interface IFare {
    total: IPrice;
    ticket: IPrice;
    supplierFee: IPrice;
    yandexFee: IPrice;
}

export interface IBusRide {
    id: string;
    departure: TInstantDateTime;
    arrival?: TInstantDateTime;
    duration?: number;
    pointFrom: IBusPoint;
    pointTo: IBusPoint;
    titlePointFrom: IBusPoint;
    titlePointTo: IBusPoint;
    busDescription?: string;
    routeName?: string;
    routeNumber?: string;
    supplier: ILegalEntity;
    carrier?: ILegalEntity;
    freeSeats?: number;
    ticketLimit?: number;
    benefits: EBusBenefits[];
    refundConditions?: string;
}

export interface IBusPoint {
    supplierDescription: string;
    type?: EPointType;
    title?: string;
    timezone?: string;
    address?: string;
    coordinates?: ICoordinates;
}

export interface IBusTicket {
    id: string;
    seat?: string;
    ticketType: EBusTicketType;
    price: IFare;
    passenger: IBusPassenger;
    refundPartInfo?: IRefundPartInfo;
}

export interface IBusPassenger {
    firstName: string;
    lastName: string;
    patronymic?: string;
    birthDate: TDate;
    documentNumber: string;
    documentType: EDocumentType;
    sex?: EGender;
    citizenship?: number;
}

export enum EPointType {
    SETTLEMENT = 'SETTLEMENT',
    STATION = 'STATION',
}

export enum EBusTicketType {
    FULL = 'FULL',
    CHILD = 'CHILD',
    BAGGAGE = 'BAGGAGE',
    DISCOUNT = 'DISCOUNT',
}

export enum EBusBenefits {
    COFFEE = 'COFFEE',
    CHARGER = 'CHARGER',
    PRESS = 'PRESS',
    TV = 'TV',
    WI_FI = 'WI_FI',
    NO_TICKET_REQUIRED = 'NO_TICKET_REQUIRED',
    WC = 'WC',
    CONDITIONER = 'CONDITIONER',
    COMMON_AUDIO = 'COMMON_AUDIO',
}
