import {
    TDate,
    TInstantDateTime,
    TInteger,
    IPrice,
    TUuid,
} from '../../../common/common';
import {IBusServiceInfo, IBusPassenger, EBusTicketType} from './bus-service';
import {IHotelServiceInfo} from './hotel-service';
import {ITrainServiceInfo} from './models/trainService/train-service';
import {IPromoCampaigns} from '../promo-campaigns';
import {IHotelGuest} from '../hotels';
import {EDisplayOrderState} from '../getOrderHappyPage/models/models';

export interface ICreateHotelServiceParams {
    token: string;
    checksum: string;
    selectedBedGroupIndex: TInteger;
    guests: IHotelGuest[];
}

export interface ICreateTrainServiceParams {
    offerId: TUuid;
    passengers: ITrainPassengerParams[];
    trainTestContextToken: string;

    /**
     * Идентификатор "связанных сегментов".
     * Используется в качестве временного решения для провязки заказов ЖД для pre-trip.
     * @deprecated
     */
    correlationId?: string;
}

export interface ITrainPassengerParams {
    index: TInteger;
    birthDate?: TDate;
    docId: string;
    firstName: string;
    lastName: string;
    patronymic: string;
    phone?: string;
    email?: string;
}

export interface ICreateBusesServiceParams {
    offerId: TUuid;
    busTestContextToken?: string;
    tickets: ICreateBusesTicket[];
}

export interface ICreateBusesTicket {
    passenger: IBusPassenger;
    ticketType: EBusTicketType;
    seat?: string;
}

/**
 * Передается в метод расчета суммы к возврату. Контекст возвращаемой части заказа
 */
export interface IRefundPartCtx {
    info: string;
}

export interface IRefund {
    id: TUuid;
    state: ERefundState;
    type: ERefundType;
    refundAmount: IPrice | null;
    paymentRefundReceiptUrls: string[];
    refundBlankToken: string;
}

export interface IRefundPartInfo {
    type: ERefundPartType;
    state: ERefundPartState;
    context: IRefundPartCtx;
    refund: IRefund | null;
}

export interface IGenericOrderInfo {
    /**
     * Внутренный технический идентификатор заказа. Используется в ссылках и вызовах API.
     */
    id: TUuid;
    /**
     * Идентификатор заказа для отображения пользователю. Поддерживается в некоторых методах API.
     */
    prettyId: string;
    /**
     * Внутреннее состояние заказа для управления процессом бронирования.
     * Нужен клиентам API для понимания в какой точке бронирования находится заказ
     * и какие внешние действия стоит предпринимать (см. описание в README процесса бронирования).
     * Не отображается пользователю напрямую.
     */
    state: EGenericOrderState;
    /**
     * Причина отмены заказа.
     * Отображается пользователю когда заказ переходит в состояние CANCELLED в виде
     * сообщения типа "время брони истекло"
     */
    cancellationReason?: ECancellationReason;
    /**
     * Упрощённое состояние заказа для отображения пользователю.
     * Более общий и человеко-понятный статус, используется, например, для фильтрации заказов при выгрузке списоком.
     * Вычисляется на backend-е, т.к. на него завязано бизнес-логика.
     */
    displayState: EDisplayOrderState;
    /**
     * Срок истечения брони по неоформленному заказу.
     */
    expiresAt?: TInstantDateTime;
    /**
     * Дата и время исполнения заказа.
     */
    servicedAt?: TInstantDateTime;

    services: IGenericService[];

    orderPriceInfo: IOrderPriceInfo;
    // refundInfo?: RefundInfo;
    payment: IPaymentInfo;

    /**
     * Контакты для связи. Используются в том числе и для получения доступа в заказу.
     */
    contactInfo: IContactInfo;

    /**
     * Информация о возврате для всего заказа
     */
    refundPartInfo: IRefundPartInfo;

    /**
     * id поездки, к которой привязан заказ. Если поездки еще нет, то отсутствует
     */
    tripId?: TUuid | null;
}

export interface IPromoSubscriptionParams {
    subscribe: boolean;
    timezone: string;
    language: string;
    nationalVersion: string;
}

export interface IUserInfo {
    ip: string;
    geoId: TInteger;
    userAgent: string;
    mobile: boolean;
    // поля uid (passport?) / yandexUid / login передаются через заголовки запросов
}

export enum EGenericOrderState {
    NEW = 'NEW',
    IN_PROGRESS = 'IN_PROGRESS',
    RESERVED = 'RESERVED',
    STARTING_PAYMENT = 'STARTING_PAYMENT',
    WAITING_PAYMENT = 'WAITING_PAYMENT',
    PAYMENT_FAILED = 'PAYMENT_FAILED',
    CONFIRMED = 'CONFIRMED',
    CANCELLED = 'CANCELLED',
    REFUNDED = 'REFUNDED',
}

export enum ECancellationReason {
    EXPIRED = 'EXPIRED',
    RESERVATION_FAILED = 'RESERVATION_FAILED',
    CONFIRMATION_FAILED = 'CONFIRMATION_FAILED',
    USER_CANCELLED = 'USER_CANCELLED',
}

export interface IOrderPriceInfo {
    price: IPrice;
    originalPrice: IPrice;
    discountAmount: IPrice;

    promoCampaigns: IPromoCampaigns;
    promoCodeApplicationResults: IPromoCodeApplicationResult[];
}

export interface IPromoCodeApplicationResult {
    code: string;
    type: EPromoCodeApplicationResultType;
    discountAmount?: IPrice;
}

export enum EPromoCodeApplicationResultType {
    SUCCESS = 'SUCCESS',
    NOT_FOUND = 'NOT_FOUND',
    NOT_APPLICABLE = 'NOT_APPLICABLE',
    ALREADY_APPLIED = 'ALREADY_APPLIED',
    EXPIRED = 'EXPIRED',
}

export interface IPaymentInfo {
    paymentUrl: string;
    receipts: IReceiptItem[];
    errorInfo: EPaymentError;
}

export interface IReceiptItem {
    url: string;
    type: EFiscalReceiptType;
}

export enum EFiscalReceiptType {
    ACQUIRE = 'ACQUIRE',
    CLEAR = 'CLEAR',
    REFUND = 'REFUND',
}

export enum EPaymentError {
    // есть разные конкретные коды ошибок, но пока не ясно какие из них стоит явно выделять,
    // т.к. есть коды вроде BLACKLISTED, которые не рекомендуется явно отображать
    AUTHORIZATION_REJECT = 'AUTHORIZATION_REJECT',
    EXPIRED_CARD = 'EXPIRED_CARD',
    FAIL_3DS = 'FAIL_3DS',
    LIMIT_EXCEEDED = 'LIMIT_EXCEEDED',
    NOT_ENOUGH_FUNDS = 'NOT_ENOUGH_FUNDS',
    TRANSACTION_NOT_PERMITTED = 'TRANSACTION_NOT_PERMITTED',
    USER_CANCELLED = 'USER_CANCELLED',
    RESTRICTED_CARD = 'RESTRICTED_CARD', // возможно стоит спрятать за GENERAL_PAYMENT_ERROR
    BLACKLISTED = 'BLACKLISTED', // возможно стоит спрятать за GENERAL_PAYMENT_ERROR
    GENERAL_PAYMENT_ERROR = 'GENERAL_PAYMENT_ERROR',
}

export interface IContactInfo {
    email: string;
    phone: string;
}

export interface IGenericService {
    id: TUuid;

    serviceType: EServiceType;
    state: EServiceState;

    hotelInfo: IHotelServiceInfo;
    trainInfo: ITrainServiceInfo;
    busInfo: IBusServiceInfo;

    /**
     * Информация о возврате части услуги
     */
    refundPartInfo: IRefundPartInfo;
}

export enum EServiceType {
    HOTEL = 'HOTEL',
    TRAIN = 'TRAIN',
    BUS = 'BUS',
}

export enum EDeviceType {
    DESKTOP = 'desktop',
    // TOUCH = 'touch', // ?
    MOBILE = 'mobile',
}

export enum ERefundPartType {
    ORDER = 'order',
    SERVICE = 'service',
    SERVICE_PART = 'service_part',
}

export enum ERefundPartState {
    DISABLED = 'DISABLED',
    ENABLED = 'ENABLED',
    REFUNDED = 'REFUNDED',
    DEPENDENT = 'DEPENDENT',
    OFFLINE_ENABLED = 'OFFLINE_ENABLED',
}

export enum EServiceState {
    IN_PROGRESS = 'IN_PROGRESS',
    RESERVED = 'RESERVED',
    CONFIRMED = 'CONFIRMED',
    CANCELLED = 'CANCELLED',
    REFUNDED = 'REFUNDED',
}

export enum ERefundState {
    IN_PROGRESS = 'IN_PROGRESS',
    REFUNDED = 'REFUNDED',
    FAILED = 'FAILED',
}

enum ERefundType {
    USER_REFUND = 'USER_REFUND',
    TRAIN_OFFICE_REFUND = 'TRAIN_OFFICE_REFUND',
    TRAIN_INSURANCE_AUTO_RETURN = 'TRAIN_INSURANCE_AUTO_RETURN',
}

export enum EGenericOrderSource {
    /**
     * Запрос с уточнением данных у партнера
     */
    ORDER_PAGE = 'ORDER_PAGE',

    OTHER = 'OTHER',
}
