import {TUuid} from '../../../../common/common';
import {
    IContactInfo,
    ICreateBusesServiceParams,
    ICreateHotelServiceParams,
    ICreateTrainServiceParams,
    IPromoSubscriptionParams,
    IUserInfo,
} from '../common';
import {IAppliedPromoCampaigns} from '../../../../hotels/booking-flow/models';

export interface IRequest {
    /**
     * Уникальный идентификатор заказа для предотвращения создания задвоенных заказов в случе неполадок.
     * Отличается от id заказа, который будет возвращён после создания.
     * При повторных попытках вызвать create_order для текущего заказа
     * должен использоваться один и от же deduplicationKey.
     */
    deduplicationKey: TUuid;
    label: string;
    /**
     * Обязательно должна быть указана хотя бы одна из поддерживаемых услуг.
     */
    hotelServices: ICreateHotelServiceParams[];
    trainServices: ICreateTrainServiceParams[];
    busesServices: ICreateBusesServiceParams[];

    contactInfo: IContactInfo;
    userInfo: IUserInfo;
    subscriptionParams: IPromoSubscriptionParams;

    // TODO(mbobrov): think of activated promo_codes
    promoCodes: string[];

    /**
     * Запуск фиктивных тестовых сценариев оплаты по заранее определённым параметрам из переданного контекста.
     * Использование тестового контекста доступно только в тестовой среде.
     */
    paymentTestContextToken: string;
    /**
     * История действий пользователя до создания заказа в json
     */
    orderHistory: object;

    appliedPromoCampaigns?: IAppliedPromoCampaigns;
}
