import {TUuid} from '../../../../common/common';
import {
    IContactInfo,
    ICreateHotelServiceParams,
    ICreateTrainServiceParams,
    IPromoSubscriptionParams,
    IUserInfo,
} from '../common';

/**
 * Запрос аналогичен тому, что посылается при создании заказа,
 * за тем исключением, что данные гостей/пассажиров передавать не нужно.
 */
export interface IRequest {
    deduplicationKey: TUuid;

    hotelServices?: ICreateHotelServiceParams[];
    trainServices?: ICreateTrainServiceParams[];

    contactInfo: IContactInfo;
    userInfo: IUserInfo;
    subscriptionParams: IPromoSubscriptionParams;

    // TODO(mbobrov): think of activated promo_codes
    promoCodes?: string[];

    paymentTestContextToken?: string;
}
