enum ETrainOrderErrorCode {
    NO_PLACES = 'NO_PLACES',
    INVALID_BONUS_CARD = 'INVALID_BONUS_CARD',
    NAME_REQUIRED_LATIN_LETTERS = 'NAME_REQUIRED_LATIN_LETTERS',
    TARIFF_ERROR = 'TARIFF_ERROR',
    TRY_LATER = 'TRY_LATER',
    TOO_LATE = 'TOO_LATE',
    INVALID_DOCUMENT_NUMBER = 'INVALID_DOCUMENT_NUMBER',
    TOO_LATE_FOR_ORDER = 'TOO_LATE_FOR_ORDER',
    CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE = 'CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE',
    REBOOKING_FAILED = 'REBOOKING_FAILED',
    UNKNOWN_PARTNER_ERROR = 'UNKNOWN_PARTNER_ERROR',
}

interface ITrainOrderNoPlacesError {
    code: ETrainOrderErrorCode.NO_PLACES;
}

interface ITrainOrderInvalidBonusCardError {
    code: ETrainOrderErrorCode.INVALID_BONUS_CARD;
}

interface ITrainOrderNameRequiredLatinLettersError {
    code: ETrainOrderErrorCode.NAME_REQUIRED_LATIN_LETTERS;
}

interface ITrainOrderTariffError {
    code: ETrainOrderErrorCode.TARIFF_ERROR;
}

interface ITrainOrderTryLetterError {
    code: ETrainOrderErrorCode.TRY_LATER;
}

interface ITrainOrderTooLateError {
    code: ETrainOrderErrorCode.TOO_LATE;
}

interface ITrainOrderInvalidDocumentNumberError {
    code: ETrainOrderErrorCode.INVALID_DOCUMENT_NUMBER;
    params: {
        passengerIndex: number;
    };
}

interface ITrainOrderTooLateForOrderError {
    code: ETrainOrderErrorCode.TOO_LATE_FOR_ORDER;
    params: {
        salesClosesBeforeDeparture: string;
        departure: string;
    };
}

interface ITrainOrderCitizenshipNotMatchDocumentTypeError {
    code: ETrainOrderErrorCode.CITIZENSHIP_NOT_MATCH_DOCUMENT_TYPE;
    params: {
        passengerIndex: number;
    };
}

interface ITrainOrderRebookingFailedError {
    code: ETrainOrderErrorCode.REBOOKING_FAILED;
}

interface ITrainOrderUnknownPartnerError {
    code: ETrainOrderErrorCode.UNKNOWN_PARTNER_ERROR;
}

export type TTrainOrderError =
    | ITrainOrderNoPlacesError
    | ITrainOrderInvalidBonusCardError
    | ITrainOrderNameRequiredLatinLettersError
    | ITrainOrderTariffError
    | ITrainOrderTryLetterError
    | ITrainOrderTooLateError
    | ITrainOrderInvalidDocumentNumberError
    | ITrainOrderTooLateForOrderError
    | ITrainOrderCitizenshipNotMatchDocumentTypeError
    | ITrainOrderRebookingFailedError
    | ITrainOrderUnknownPartnerError;

/**
 * @deprecated
 */
export interface ITrainOrderOldErrorInfo {
    type: ETrainOrderOldErrorType;
    messageCode: ETrainOrderApiOldErrorMessageCode;
    message: string;
    messageParams: string[];
}

/**
 * @deprecated
 */
enum ETrainOrderOldErrorType {
    PARTNER_ERROR = 'PARTNER_ERROR',
    PROCESS_EXCEPTION_STATE = 'PROCESS_EXCEPTION_STATE',
    REBOOKING_FAILED = 'REBOOKING_FAILED',
}

/**
 * @deprecated
 */
enum ETrainOrderApiOldErrorMessageCode {
    TRY_LATER = 'TRY_LATER',
    REBOOKING_FAILED = 'REBOOKING_FAILED',
    PARTNER_ERROR = 'PARTNER_ERROR',
}
