import {TInstantDateTime, TInteger} from '../../../../../common/common';
import {
    ITrainInfo,
    ITrainPassenger,
    ITrainRailwayStation,
    ITrainWarningInfo,
} from '../../../trains';
import {ITrainOrderOldErrorInfo, TTrainOrderError} from './error';

export interface ITrainServiceInfo {
    error: TTrainOrderError & ITrainOrderOldErrorInfo;

    direction: EDirection;
    segmentIndex: TInteger;

    partnerOrderId: TInteger;
    reservationNumber: string;
    stationFrom: ITrainRailwayStation;
    stationTo: ITrainRailwayStation;
    trainInfo: ITrainInfo;
    carType: string;
    compartmentGender: string | null;
    arrival: TInstantDateTime;
    departure: TInstantDateTime;
    partner: string;
    carNumber: string;
    specialNotice: string;
    warnings: ITrainWarningInfo[] | null;
    twoStorey: boolean;
    coachOwner: string;
    companyTitle?: string;
    passengers: ITrainPassenger[];
    rebookingAvailable: boolean;
    downloadBlankToken?: string;
}

export enum EDirection {
    FORWARD = 'FORWARD',
    BACKWARD = 'BACKWARD',
}
