import {IPrice} from 'common/common';

export default interface IGetOrderForBusinessTripDocResponse {
    /**
     * Имена гостей, будут выведены через запятую
     * @example ['Дмитрий Каток']
     */
    guestNames: string[];

    /**
     * Почта пользователя
     * @example 'KATOK@yandex.ru'
     */
    userEmail: string;

    /**
     * Дата обращения
     * @example '27.06.2022'
     */
    displayApplicationDate: string;

    /**
     * Имя отеля
     * @example 'Greenfeel'
     */
    hotelName: string;

    /**
     * Адрес отеля
     * @example 'Россия, Псков, улица Металлистов, 25'
     */
    hotelAddress: string;

    /**
     * Дата заселения в отель
     * @example '30.05.2022'
     */
    displayCheckinDate: string;

    /**
     * Дата выселения
     * @example '01.06.2022'
     */
    displayCheckoutDate: string;

    /**
     * Номера чеков, будут выведены через запятую
     * @example ['311', '441', '115В']
     */
    receiptNumbers: string[];

    /**
     * Общая стоимость
     * @example {
     *     value: 6100,
     *     currency: 'RUB'
     * }
     */
    totalPrice: IPrice;
}
