import {
    IAppliedPromoCampaigns,
    IDeferredPayment,
} from 'hotels/booking-flow/models';
import {IAirportReferenceDTO} from 'avia/common/IReferenceDTO';
import {
    IGenericService,
    IOrderPriceInfo,
} from 'travel/orders/generic-booking-flow/common';

import {
    IPrice,
    TDate,
    TInstantDateTime,
    TInteger,
    TLocalDateTime,
    TUuid,
} from '../../../../common/common';
import {EHotelOrderStatus} from '../../../../common/hotel_orders';
import {
    IGeoHotelInfo,
    IHotelCancellationDetails,
    IHotelGuest,
    IHotelOfferLegalInfo,
    IHotelOrderConfirmationInfo,
    IHotelOrderRefundInfo,
    IHotelPriceInfo,
    IHotelSearchRequestInfo,
} from '../../hotels';
import {
    ITrainInfo,
    ITrainPassenger,
    ITrainRailwayStation,
    ITrainWarningInfo,
} from '../../trains';
import {IPromoCampaigns} from '../../promo-campaigns';

export enum EPaymentError {
    AUTHORIZATION_REJECT = 'AUTHORIZATION_REJECT',
    EXPIRED_CARD = 'EXPIRED_CARD',
    FAIL_3DS = 'FAIL_3DS',
    LIMIT_EXCEEDED = 'LIMIT_EXCEEDED',
    NOT_ENOUGH_FUNDS = 'NOT_ENOUGH_FUNDS',
    TRANSACTION_NOT_PERMITTED = 'TRANSACTION_NOT_PERMITTED',
    USER_CANCELLED = 'USER_CANCELLED',
    RESTRICTED_CARD = 'RESTRICTED_CARD',
    BLACKLISTED = 'BLACKLISTED',
    OTHER = 'OTHER',
}

export interface IHotelOrder {
    id: TUuid;
    yandexOrderId: string;
    orderInfo: IHotelOrderInfo;
    guestInfo: IHotelOrderGuestInfo;
    status: EHotelOrderStatus;
    orderCancellationDetails: IHotelCancellationDetails;
    payment: IHotelOrderPaymentInfo;
    confirmationInfo: IHotelOrderConfirmationInfo;
    refundInfo: IHotelOrderRefundInfo;
    orderPriceInfo?: IOrderPriceInfo;
    appliedPromoCampaigns?: IAppliedPromoCampaigns;
}

export interface IAviaOrder {
    id: TUuid;
    prettyId: string;
    partner: string;
    variantId: string;
    email: string;
    phone: string;
    airReservation: IAviaOrderReservation;
    travellers: IAviaOrderTraveller[];
    preliminaryPrice: IPrice;
    price: IPrice;
    agencyMarkup?: IPrice;
    state: EAviaOrderState;
    edisplayOrderState: EDisplayOrderState;
    timeLimitAt: TLocalDateTime;
    fareRulesUrl?: string;
    errorCode?: EAviaOrderError;
    reference: IAviaOrderReference;
    servicedAt: TLocalDateTime;
}

export interface ITrainOrder {
    id: TUuid;
    prettyId: string;
    status: ETrainOrderStatus;
    error?: ITrainOrderError;
    reservedTo: TInstantDateTime;
    maxPendingTill: TInstantDateTime;
    paymentError?: EPaymentError;
    paymentUrl?: string;
    insuranceStatus: ETrainOrderInsuranceStatus;

    // todo(tld-13): most of the fields below should be removed soon, use the data from the segments field instead
    partnerOrderId: TInteger;
    stationFrom: ITrainRailwayStation;
    stationTo: ITrainRailwayStation;
    trainInfo: ITrainInfo;
    carType: string; // TODO (mbobrov): enumerize
    compartmentGender?: string;
    arrival: TInstantDateTime;
    departure: TInstantDateTime;
    partner: string; // always im
    carNumber: string;
    specialNotice?: string;
    warnings: ITrainWarningInfo[];
    twoStorey: boolean;
    coachOwner: string;
    companyTitle?: string;
    // todo(tld-13): previous todo end (+ include the passengers field below)

    canChangeElectronicRegistrationTill?: TInstantDateTime;
    passengers: ITrainPassenger[];
    onlyFullReturnPossible: boolean;
    paymentReceiptUrl: string;
    customerEmail: string;
    customerPhone: string;
    rebookingAvailable: boolean;
    reservationProlonged: boolean;

    services: IGenericService[];
}

// --- модели IHotelOrder ---

export interface IHotelOrderInfo {
    travelToken: string;
    label: string;
    checksum: string;
    sessionKey: string;
    basicHotelInfo: IGeoHotelInfo;
    partnerHotelInfo: any;
    partnerRoomInfo: any;
    bedGroups: any; // подумать, можно ли перемапить в енум
    requestInfo: IHotelSearchRequestInfo;
    rateInfo: IHotelPriceInfo;
    pansionInfo: any; // подумать можно ли перемапить в енум
    cancellationInfo: any;
    legalInfo: IHotelOfferLegalInfo;
    partnerId: EPartnerId;
    promoCampaigns?: IPromoCampaigns;
}

export interface IHotelOrderGuestInfo {
    customerEmail: string;
    customerPhone: string;
    allowSubscription: boolean;
    guests: IHotelGuest[];
}

export enum EPartnerId {
    BNOVO = 'bnovo',
    EXPEDIA = 'expedia',
    TRAVELLINE = 'travelline',
}

export interface IHotelOrderPaymentInfoReceiptItem {
    url: string;
    type: string; // TODO(mbobrov) add enum
}

export interface IHotelOrderPaymentInfo {
    receipts: IHotelOrderPaymentInfoReceiptItem[];
    errorInfo: EPaymentError;
    next?: IDeferredPayment;
    amountPaid?: IPrice;
    usesDeferredPayments?: boolean;
    usesZeroFirstPayment: boolean;
}

// --- модели ITrainOrder ---

export interface ITrainOrderError {
    type: 'PARTNER_ERROR' | 'PROCESS_EXCEPTION_STATE' | 'TRUST_ERROR';
    messageCode: 'TRY_LATER' | 'PARTNER_ERROR' | null;
    message: string;
    messageParams: string[] | null;
}

export enum ETrainOrderStatus {
    WAITING_RESERVATION = 'WAITING_RESERVATION',
    WAITING_PAYMENT = 'WAITING_PAYMENT',
    CANCELLED = 'CANCELLED',
    START_PAYMENT_FAILED = 'START_PAYMENT_FAILED',
    PAYMENT_FAILED = 'PAYMENT_FAILED',
    CONFIRMATION_FAILED = 'CONFIRMATION_FAILED',
    WAITING_CONFIRMATION = 'WAITING_CONFIRMATION',
    CONFIRMED = 'CONFIRMED',
    WAITING_REFUND = 'WAITING_REFUND',
    IN_PROGRESS = 'IN_PROGRESS',
}

export enum ETrainOrderInsuranceStatus {
    DISABLED = 'DISABLED',
    NEW = 'NEW',
    PRICED = 'PRICED',
    PRICING_FAILED = 'PRICING_FAILED',
    CHECKED_OUT = 'CHECKED_OUT',
    CHECKOUT_FAILED = 'CHECKOUT_FAILED',
    AUTO_RETURN = 'AUTO_RETURN',
}

// --- модели IAviaOrder ---

export interface IAviaOrderReservation {
    pnr: string;
    partnerRef?: string;
    segments: IAviaOrderReservationSegment[];
}

export interface IAviaOrderReservationSegment {
    flights: IAviaOrderReservationSegmentFlight[];
}

export interface IAviaOrderReservationSegmentFlight {
    id: string;
    from: number;
    to: number;
    marketingAviaCompany?: number;
    operatingAviaCompany?: number;
    number: string;
    arrival: TLocalDateTime;
    departure: TLocalDateTime;
    stops?: IAviaOrderReservationSegmentFlightStop[];
    fareTerms: IAviaOrderReservationSegmentFlightFareTerm;
    seatsLeft?: number;
    aircraftSeats: IAviaOrderReservationSegmentFlightSeatsInfo;
}

export interface IAviaOrderReservationSegmentFlightStop {
    airportId: number;
    terminal?: string;
}

export interface IAviaOrderReservationSegmentFlightFareTerm {
    baseClass: EClassOfService;
    tariffGroupName: string;
    terms: Map<string, IAviaOrderReservationSegmentFlightTermValue>;
}

export enum EClassOfService {
    ECONOMY = 'economy',
    BUSINESS = 'business',
    FIRST = 'first',
    PREMIUM_ECONOMY = 'premium_economy',
    OTHER = 'other',
}

export interface IAviaOrderReservationSegmentFlightTermValue {
    availability: EAviaOrderReservationSegmentFlightTermValueAvailability;
    charge?: IAviaOrderReservationSegmentFlightTermValueChargeValue;
    miles?: string;
    places?: number;
    weight?: number;
    size?: string;
    specialNotes?: string[];
}

export interface IAviaOrderReservationSegmentFlightTermValueChargeValue {
    value?: number;
    currency: string;
}

export enum EAviaOrderReservationSegmentFlightTermValueAvailability {
    FREE = 'FREE',
    CHARGE = 'CHARGE',
    NOT_AVAILABLE = 'NOT_AVAILABLE',
}

export interface IAviaOrderReservationSegmentFlightSeatsInfo {
    total?: number;
    economy?: number;
    comfort?: number;
    business?: number;
    first?: number;
}

export interface IAviaOrderTraveller {
    id: string;
    firstName: string;
    middleName: string;
    lastName: string;
    sex: EAviaOrderTravellerSex;
    category: EAviaOrderTravellerPassengerCategory;
    dateOfBirth: TDate;
    documentNumber: string;
    documentValidTill: TDate;
    documentType: EAviaOrderTravellerDocumentType;
    priceInfo: IAviaOrderTravellerPriceInfo;
    ticketNumber?: string;
    loyaltyProgramInternalCode: string | null;
    loyaltyProgramAccountNumber: string | null;
}

export enum EAviaOrderTravellerSex {
    MALE = 'male',
    FEMALE = 'female',
}

export enum EAviaOrderTravellerPassengerCategory {
    ADULT = 'adult',
    CHILD = 'child',
    INFANT = 'infant',
}

export enum EAviaOrderTravellerDocumentType {
    PASSPORT = 'passport',
    INTERNATIONAL_PASSPORT_RU = 'internation_passport_ru',
    BIRTH_CERTIFICATE = 'birth_certificate',
    NATIONAL_PASSPORT = 'national_passport',
}

export interface IAviaOrderTravellerPriceInfo {
    fare: IPrice;
    tax: IPrice;
    total: IPrice;
}

export enum EAviaOrderState {
    NEW = 'new',
    BOOKING = 'booking',
    BOOKED = 'booked',
    PROCESSING_ERROR = 'processing_error',
    TICKETED = 'ticketed',
    UNRECOGNIZED = 'unrecognized',
}

export enum EDisplayOrderState {
    OS_IN_PROGRESS = 'OS_IN_PROGRESS',
    OS_AWAITS_PAYMENT = 'OS_AWAITS_PAYMENT',
    OS_CANCELLED = 'OS_CANCELLED',
    OS_FULFILLED = 'OS_FULFILLED',
    OS_REFUNDED = 'OS_REFUNDED',
}

export enum EAviaOrderError {
    VARIANTS_NOT_AVAILABLE = 'variants_not_available',
    PRICE_CHANGED = 'price_changed',
    PAYMENT_FAILED = 'payment_failed',
}

export interface IAviaOrderReference {
    airlines?: IAviaOrderReferenceAirline[];
    airports?: IAirportReferenceDTO[];
    settlements?: IAviaOrderReferenceSettlement[];
    partnerInfo?: any; // TODO (frontend, mbobrov) - выяснить используется ли, если да, то специфицировать
    loyaltyPrograms: ILoyaltyProgramInfo[];
}

export interface IAviaOrderReferenceAirline {
    id: number;
    alliance?: string;
    title: string;
    url?: string;
    logoSvg?: string;
    color: string;
    sirenaCode?: string;
    iataCode?: string;
}

export interface IAviaOrderReferenceSettlement {
    id: number;
    countryId: number;
    title: string;
    phraseFrom?: string;
    phraseIn?: string;
    phraseTo?: string;
}

export interface ILoyaltyProgramInfo {
    internalCode: string;
    name: string;
}
