import {
    TLong,
    TDate,
    TInteger,
    ICoordinates,
    ECurrencyType,
    TLocalDateTime,
} from 'common/common';
import {IGeoRegion} from 'hotels/common/common';

import {IPromoCampaigns} from './promo-campaigns';

export interface IHotelOfferInfo {
    travelToken: string;
    label: string;
    checksum: string;
    sessionKey: string;
    basicHotelInfo: IGeoHotelInfo;
    partnerHotelInfo: IPartnerHotelInfo;
    partnerRoomInfo: IRoomContentInfo;
    bedGroups: IBedGroupInfo[];
    requestInfo: IHotelSearchRequestInfo;
    rateInfo: IHotelPriceInfo;
    pansionInfo: ILocalizedPansionInfo;
    cancellationInfo: ICancellationInfo;
    cancellationInfoUnfiltered: ICancellationInfo;
    legalInfo: IHotelOfferLegalInfo;
    partnerId: EHotelPartnerId;
    directPartner: boolean;
    promoCampaigns: IPromoCampaigns;
}

export interface IGeoHotelInfo {
    permalink: TLong;
    hotelSlug: string;
    name: string;
    address: string;
    phone: string;
    stars: TInteger;
    rating: number;
    coordinates: ICoordinates;
    imageUrlTemplate: string;
    workingHours: string;
    legalInfo: IGeoHotelInfoLegalInfo;
    locationType: EHotelLocationType;
    breadcrumbs: IHotelBreadcrumbs;
}

export interface IGeoHotelInfoLegalInfo {
    inn: string;
    ogrn: string;
    address: string;
}

export enum EHotelLocationType {
    MOSCOW = 'MOSCOW',
    RUSSIA = 'RUSSIA',
    GLOBAL = 'GLOBAL',
}

export interface IHotelBreadcrumbs {
    geoRegions: IGeoRegion[];
}

export interface IPartnerHotelInfo {
    propertyId: string;
    name: string;
    phone: string;
    address: IHotelAddress;
    location: ILocation;
    ratings: IRatings;
    amenities: Map<string, IAmenity>;
    descriptions: IDescriptions;
    images: IImage[];
    checkin: ICheckin;
    checkout: ICheckout;
    fees: IFees;
    policies: IPolicies;
}

export interface IHotelAddress {
    countryCode: string;
    city: string;
    line1: string;
    line2: string;
}

export interface ILocation {
    coordinates: ICoordinates;
}

export interface IRatings {
    property: IRating;
}

export interface IRating {
    type: string;
    rating: string;
}

export interface IAmenity {
    id: number;
    name: string;
}

export interface IDescriptions {
    location: string;
    rooms: string;
    dining: string;
    amenities: string;
    businessAmenities: string;
}

export interface IImage {
    links: Map<string, IImageLink>;
}

export interface IImageLink {
    href: string;
    method: string;
}

export interface ICheckin {
    beginTime: string;
    endTime: string;
    specialInstructions: string;
    instructions: string;
}

export interface ICheckout {
    time: string;
}

export interface IFees {
    mandatory: string;
    optional: string;
}

export interface IPolicies {
    knowBeforeYouGo: string;
}

export interface IRoomContentInfo {
    name: string;
    descriptions: IRoomDescriptions;
    amenities: Map<string, IAmenity>;
    images: IImage[];
}

export interface IRoomDescriptions {
    overview?: string;
}

export interface IBedGroupInfo {
    id: string;
    description: string;
}

export interface IHotelSearchRequestInfo {
    checkinDate: TDate;
    checkoutDate: TDate;
    numAdults: TInteger;
    childAges: TInteger[];
    selectedBedGroupIndex: TInteger;
}

export interface IHotelPriceInfo {
    hotelCharges: IHotelCharges;
    extraCharges: IExtraFeeRate[];
}

export interface IHotelCharges {
    nightly: IHotelNightlyRate[];
    daily: IHotelNightlyRate[];
    totals: ITotalsBreakdown;
}

export interface IHotelNightlyRate {
    taxesAndFees: IHotelFeeRate[];
    base: IBaseRate;
}

export interface IHotelFeeRate extends IBaseRate {
    type: EHotelFeeType;
}

export enum EHotelFeeType {
    TAX_AND_SERVICE_FEE = 'TAX_AND_SERVICE_FEE',
    EXTRA_PERSON_FEE = 'EXTRA_PERSON_FEE',
    COMPENSATION = 'COMPENSATION',
    PROPERTY_FEE = 'PROPERTY_FEE',
    SALES_TAX = 'SALES_TAX',
    ADJUSTMENT = 'ADJUSTMENT',
}

/** TODO: заменить на общий IPrice из common */
export interface IBaseRate {
    amount: string;
    currency: ECurrencyType;
}

export interface ITotalsBreakdown {
    base: IBaseRate;
    taxesAndFees: IHotelFeeRate[];
    taxesAndFeesSum: IBaseRate;
    grand: IBaseRate;
}

export interface IExtraFeeRate {
    type: EExtraFeeRateType;
    payable: IBaseRate;
    face: IBaseRate;
}

export enum EExtraFeeRateType {
    MANDATORY_FEE = 'MANDATORY_FEE',
    RESORT_FEE = 'RESORT_FEE',
    MANDATORY_TAX = 'MANDATORY_TAX',
}

export interface ILocalizedPansionInfo {
    id: EPansionType;
    name: string;
}

export enum EPansionType {
    // All inclusive
    PT_AI = 1,
    // Bed and breakfast (Завтрак)
    PT_BB = 2,
    // Full board (Завтрак, обед, ужин; пансион)
    PT_FB = 3,
    // Half board (Завтрак и ужин; полупансион)
    PT_HB = 5,
    // Room only
    PT_RO = 7,
    // Ultra All Inclusive
    PT_UAI = 8,
    // Light All Inclusive
    PT_LAI = 9,
    // Dinner Only (только ужин)
    PT_BD = 10,
}

export interface ICancellationInfo {
    refundable: boolean;
    penalties: ICancellationPenalty[];
    isHighlighted: boolean;
}

export interface ICancellationPenalty {
    startsAt: TLocalDateTime;
    endsAt: TLocalDateTime;
    type: ECancellationPenaltyType;
    amount: string;
    currency: ECurrencyType;
}

export enum ECancellationPenaltyType {
    NO_PENALTY = 'NO_PENALTY',
    SOME_PENALTY = 'SOME_PENALTY',
    FULL_PRICE = 'FULL_PRICE',
}

export interface IHotelOfferLegalInfo {
    hotel: IHotelOfferPartyLegalInfo;
    partner: IHotelOfferPartyLegalInfo;
    yandex: IHotelOfferPartyLegalInfo;
}

export interface IHotelOfferPartyLegalInfo {
    name: string;
    ogrn: string;
    actualAddress: string;
    legalAddress: string;
    workingHours: string;
    registryNumber: string;
}

export enum EHotelPartnerId {
    PI_BOOKING = 'PI_BOOKING',
    PI_HOTELS101 = 'PI_HOTELS101',
    PI_TRAVELLINE = 'PI_TRAVELLINE',
    PI_HOTELSCOMBINED = 'PI_HOTELSCOMBINED',
    PI_OSTROVOK = 'PI_OSTROVOK',
    PI_EXPEDIA = 'PI_EXPEDIA',
    PI_DOLPHIN = 'PI_DOLPHIN',
    PI_BNOVO = 'PI_BNOVO',
    PI_TVIL = 'PI_TVIL',
}

export enum EHotelOrderCancellationDetailsReason {
    FX_RATE_EXPIRED = 'FX_RATE_EXPIRED',
    PRICE_CHANGED = 'PRICE_CHANGED',
    SOLD_OUT = 'SOLD_OUT',
    INVALID_INPUT = 'INVALID_INPUT',
    HOLD_EXPIRED = 'HOLD_EXPIRED',
    DUPLICATE = 'DUPLICATE',
    BLACKLISTED = 'BLACKLISTED',
    USER_INTENTION = 'USER_INTENTION',
    HOTEL_INTENTION = 'HOTEL_INTENTION',
    AGREEMENT_ISSUE = 'AGREEMENT_ISSUE',
    MONEY_ACQUIRE_ERROR = 'MONEY_ACQUIRE_ERROR',
    UNKNOWN = 'UNKNOWN',
}

/**
 * Оба поля не пустые. Содержат хотя бы 1 непустой символ. Не более 80 символов всего.
 * Допустимые символы: a-zA-Z|-\s (латинские буквы, "|", "-" и любые пробельные символы).
 */
export interface IHotelGuest {
    firstName: string;
    lastName: string;
}

export interface IHotelCancellationDetails {
    reason: EHotelOrderCancellationDetailsReason;
    invalidInputDetails: IInvalidField[];
}

export interface IInvalidField {
    fieldType: EValidatedFieldType;
    guestIndex: TInteger;
}

export enum EValidatedFieldType {
    EMAIL = 'EMAIL',
    PHONE = 'PHONE',
    COUNTRY_CODE = 'COUNTRY_CODE',
    FIRST_NAME = 'FIRST_NAME',
    LAST_NAME = 'LAST_NAME',
}

export interface IHotelOrderConfirmationInfo {
    confirmationId: string;
}

export interface IHotelOrderRefundInfo {
    refundDateTime: TLocalDateTime;
    penaltyIntervalIndex: number;
    refund: IBaseRate;
    penalty: IBaseRate;
}
