export enum EAuthorizationOrderType {
    OT_HOTEL_EXPEDIA = 'OT_HOTEL_EXPEDIA',
    OT_AVIA_AEROFLOT = 'OT_AVIA_AEROFLOT',
    OT_TRAIN = 'OT_TRAIN',
    OT_BUS = 'OT_BUS',
    OT_TRAIN_ORCH = 'OT_TRAIN_ORCH',
    OT_GENERIC = 'OT_GENERIC',
}

export type TOrderId = string;
export type TYandexOrderId = string;

interface IOrderAuthorizationRequestParamsWithId {
    id: TOrderId;
    yandex_order_id?: never;
}

interface IOrderAuthorizationRequestParamsWithYandexOrderId {
    id?: never;
    yandex_order_id: TYandexOrderId;
}

export type TOrderAuthorizationRequestParams =
    | IOrderAuthorizationRequestParamsWithId
    | IOrderAuthorizationRequestParamsWithYandexOrderId;

export interface IOrderAuthorizationResponse {
    id: TOrderId;
    yandexOrderId: TYandexOrderId;
    orderType: EAuthorizationOrderType;
}
