import IYandexEdaPromocodePayload from 'travel/common/IYandexEdaPromocodePayload';

import {TInteger} from '../../common/common';
import {IOfferYandexPlusInfo} from '../../hotels/hotel-page-flow/getHotelOffers/models';
import {IWhiteLabelPoints} from '../../common/white-label/IWhiteLabelPoints';

/**
 * Данный вариант описания акций оказался неудобен, т.к. у нас есть статические акции
 * и динамические которые зависят от цены, промокодов и другого.
 * Подумать о том, чтобы использовать бейджы на бронировании, а не отдельную модель
 *
 * В задаче https://st.yandex-team.ru/HOTELS-5799 надо переехать на новый.
 */
export interface IPromoCampaigns {
    taxi2020: ITaxi2020PromoCampaignInfo;
    /** TODO: обновить нейминг, т.к. данное поле используется для промоакций МИР не только в 2020 */
    mir2020: IMirPromoCampaignInfo;
    /** Информация об использовании баллов Плюса. При отсутствии функциональность недоступна. */
    yandexPlus?: IYandexPlusCampaignInfo;
    /** Информация о промоакции с Яндекс.Едой */
    yandexEda?: IYandexEdaPromoCampaignInfo;
    /** Информация о бонусных баллах по White Label */
    whiteLabel?: IWhiteLabelCampaignInfo;
}

export interface IYandexEdaPromoCampaignInfo {
    eligible: boolean;
    data: IYandexEdaPromocodePayload;
}

export interface ITaxi2020PromoCampaignInfo {
    eligible: boolean;
}

export interface IMirPromoCampaignInfo {
    eligible: boolean;
    cashbackAmount: TInteger;
    cashbackAmountString: string;
}

export interface IYandexPlusCampaignInfo extends IOfferYandexPlusInfo {
    /* количество баллов, доступных для списания; отсутствует, если списание недоступно */
    withdrawPoints?: TInteger;
}

export interface IWhiteLabelCampaignInfo {
    eligible: boolean;
    points: IWhiteLabelPoints;
}
