import {TDate, TInstantDateTime, IPrice, TInteger} from '../../common/common';
import {IRefundPartInfo} from './generic-booking-flow/common';

export interface ITrainRailwayStation {
    id: TInteger;
    title: string;
    popularTitle: string;
    timezone: string;
    railwayTimezone: string;
    settlementId: TInteger;
    settlementGeoId: TInteger;
    settlementTitle: string;
}

export interface ITrainInfo {
    trainTitle: string;
    startStationTitle: string;
    endStationTitle: string;
    startSettlementTitle: string;
    endSettlementTitle: string;
    brandTitle: string;
    suburban: boolean;
    trainTicketNumber: string;
    trainNumber: string;
}

export interface ITrainWarningInfo {
    from: TInstantDateTime;
    to: TInstantDateTime;
    code: ETrainWarningMessageCode;
}

export enum ETrainWarningMessageCode {
    ALMOST_SIX_HOURS_TO_DEPARTURE = 'ALMOST_SIX_HOURS_TO_DEPARTURE',
    ELECTRONIC_REGISTRATION_ALMOST_EXPIRED = 'ELECTRONIC_REGISTRATION_ALMOST_EXPIRED',
    ELECTRONIC_REGISTRATION_EXPIRED = 'ELECTRONIC_REGISTRATION_EXPIRED',
    INSURANCE_AUTO_RETURN = 'INSURANCE_AUTO_RETURN',
    LESS_THEN_SIX_HOURS_TO_DEPARTURE = 'LESS_THEN_SIX_HOURS_TO_DEPARTURE',
    TICKETS_TAKEN_AWAY = 'TICKETS_TAKEN_AWAY',
    TRAIN_ALMOST_LEFT_DEPARTURE_STATION = 'TRAIN_ALMOST_LEFT_DEPARTURE_STATION',
    TRAIN_LEFT_DEPARTURE_STATION = 'TRAIN_LEFT_DEPARTURE_STATION',
    TRAIN_LEFT_START_STATION = 'TRAIN_LEFT_START_STATION',
    HAS_NON_REFUNDABLE_TARIFF = 'HAS_NON_REFUNDABLE_TARIFF',
}

export interface ITrainPassenger {
    tickets: ITrainTicket[];
    docId: string;
    docType: string; // TODO (mbobrov) enumerize
    citizenship: string;
    firstName: string;
    lastName: string;
    patronymic: string;
    age: TInteger;
    birthDate: TDate;
    sex: string;
    customerId: TInteger;
    insurance: ITrainInsurance;
    nonRefundableTariff: boolean;
    refundPartInfo: IRefundPartInfo;
}

export interface ITrainTicket {
    places: ITrainPlaceWithType[];
    tariffInfo: ITrainTariffInfo;
    rzhdStatus: string;
    amount: IPrice;
    rawTariffTitle: string;
    bookedTariffCode: string;
    payment: ITrainTicketPayment;
    blankId: TInteger;
    discountDenied: boolean;
    canChangeElectronicRegistrationTill: TInstantDateTime;
    canReturnTill: TInstantDateTime;
    pending: boolean;
}

export interface ITrainPlaceWithType {
    number: string;
    type: ETrainDisplayReservationPlaceType;
    typeText: string;
}

export enum ETrainDisplayReservationPlaceType {
    FOLDING = 'FOLDING', // 'Откидное'
    INVALIDS = 'INVALIDS', // 'Для инвалидов'
    LOWER = 'LOWER', // 'Нижний ярус'
    MIDDLE_TIER = 'MIDDLE_TIER', // 'Средний ярус'
    FOR_MOTHER_WITH_CHILD = 'FOR_MOTHER_WITH_CHILD', // 'Для матери и ребенка'
    NEAR_PASSENGERS_WITH_PETS = 'NEAR_PASSENGERS_WITH_PETS', // 'Рядом с местами для пассажиров с животными'
    NEAR_PLAYGROUND = 'NEAR_PLAYGROUND', // 'У детской площадки'
    NEAR_TABLE = 'NEAR_TABLE', // 'У стола'
    NEAR_PLAYGROUND_TABLE = 'NEAR_PLAYGROUND_TABLE', // 'У стола рядом с детской площадкой'
    CONFERENCE_ROOM = 'CONFERENCE_ROOM', // 'Переговорная'
    NOT_NEAR_TABLE = 'NOT_NEAR_TABLE', // 'Не у стола'
    LASTOCHKA_COMPARTMENT = 'LASTOCHKA_COMPARTMENT', // 'Отсек (купе) в поезде Ласточка'
    UPPER_TIER = 'UPPER_TIER', // 'Верхний ярус'
    FOR_PASSENGER_WITH_CHILDREN = 'FOR_PASSENGER_WITH_CHILDREN', // 'Для пассажира с детьми'
    FOR_PASSENGER_WITH_PET = 'FOR_PASSENGER_WITH_PET', // 'Для пассажира с животным'
}

export interface ITrainTariffInfo {
    code: string;
    title: string;
    withoutPlace: boolean;
    needDocument: boolean;
    minAge: TInteger;
    minAgeIncludesBirthday: boolean;
    maxAge: TInteger;
    maxAgeIncludesBirthday: boolean;
}

export interface ITrainTicketPayment {
    amount: IPrice;
    fee: IPrice;
    beddingAmount: IPrice;
}

export interface ITrainInsurance {
    compensation: IPrice;
    amount: IPrice;
}
