import {TUuid} from '../../../../common/common';
import ETripOrderState from './ETripOrderState';

export default interface ITripBusOrder {
    id: TUuid;

    /**
     * @example Екатеринбург — Санкт–Петербург
     */
    title: string;
    displayDateForward: string;

    /**
     * @example Екатеринбург, автостанция Орехово — Санкт–Петербург, автовокзал
     */
    description: string;

    /**
     * @example ИП Соломатин Юрий Васильевич
     */
    carrierName?: string;

    downloadBlankToken?: string;

    state: ETripOrderState;

    /**
     * Количество возвращенных билетов в заказе
     */
    refundedTicketsCount: number;
}
