import {ISubscriptionInfo, IUserPlusInfo} from './models';

/**
 * Ручка с агрегированной информацией о пользователе и пользовательской сессии для веб приложения Я.Путешествий.
 *
 * Эта ручка вызывается на каждый SSR приложения Я.Путешествий.
 * Поэтому к ней выдвигается требование по скорости ответа не дольше 100мс между отправкой и получением данных на node фронтенда.
 *
 * Поля опциональны, т.к. при недоступности одного из сервисов, мы все равно можем отдать информацию от другого.
 * Например, при недоступности информации о баллах Плюса, мы можем вернуть информацию о подписке пользователя.
 */
export interface IResponse {
    subscription?: ISubscriptionInfo;
    plusInfo?: IUserPlusInfo;
}
