# Валидация

## Форма

Форма - элемент интерфейса позволяющий вводить и отправлять данные.
Например, форма авторизации с Email и паролем пользователя.

Любая форма состоит из полей. Например:

-   имя;
-   фамилия;
-   тип документа;
-   номер документа;
-   email;
-   ...

Некоторые поля формы могут повторяться. Например, при заполнении данных бронирования, сразу можно указать несколько
документов. Такие поля можно сгруппировать, для удобства взаимодействия с ними при их дубликации:

-   документ взрослого пассажира;
-   контактная информация;
-   параметры поиска отелей;
-   ...

ER-модель такой формы будет иметь вид:
![validation scheme](images/formER.png)

Модель данных описана в файле [types/form.ts](types/form.ts).

Интерфейсы:

-   `IFormValidationInfo` - информация и форме с группами полей;
-   `IFieldGroupValidation` - группа полей;
-   `IFieldValidation` - поле формы с валидациями на `blur` и `submit`.

> Note: При необходимости такую структуру можно разложить на плоскую, которую можно использовать для именования полей
> формы или указания значению его правила.
> Последний узел это имя поля, все предыдущие узлы, это группа полей, либо индекс.

```
 name: 'adultPassenger.firstName'
 name: 'contacts.phone'

 name: 'childPassenger.0.documentType'
 name: 'childPassenger.1.documentType'
```

## Валидация

#### Правила валидации

Данные формы могут иметь ограничения. Например, длина пароля должна быть не менее 8 символов.
Эти ограничения описываются правилами валидации. Для каждого поля может быть несколько валидаций.

Правила валидации применяются к форме при потере фокуса или перед отправкой.
При этом правила на потерю фокуса и перед отправком могут быть различны.

Все правила разбиты на группы в соотвествии с типом значения поля:

-   `TCommonValidation` - общие правила, применимые к любому из полей формы;
-   `TStringValidation` - правила для поля со свободнотекстовым вводом `<input type="text" />` или `<textarea />`;
-   `TNumberValidation` - правила для поля ввода цифр `<input type="number" />`;
-   `TSelectValidation` - правила для поля выбора из списка значений `<select>`;
-   `TDateValidation` - правила для поля ввода даты. Несмотря на то что значение поля содержит строковое или числовое
    представление даты, его можно распарсить и провалидировать как дату.

#### Зависимые валидации

Зависимые валидации применяются к полю при определенных условиях. Условиями является соотвествие значений полей формы,
определенным условиям.

В качестве условий выступают значения полей формы. Например, при выборе типа документа - Паспорт РФ,
номер документа должен соотвествовать этому типу.

Условие примененния описывается интерфесом - `IDependencyCondition`.<br>

-   `IFieldPath` - для определения пути до зависимого поля;<br>
-   `TStringValue`, `TNumberValue`, `TDateValue`, `TSelectValue` - для определения значения, при котором применять правило.
    Эти интерфейсы описывают значение поля, аналогично правилам валидации, только без сообщени об ошибке.

ER-модель формы с валидациями примет вид:
![validation scheme](images/validationER.png)

Модель данных правил валидации описана в файле: [types/validations.ts](types/validations.ts).
