import {IFormValidationInfo} from '../../../form';
import {lastNameValidation} from './commonFields/lastName';
import {firstNameValidation} from './commonFields/firstName';
import {patronymicValidation} from './commonFields/patronymic';
import {sexValidation} from './commonFields/sex';
import {documentTypeValidation} from './commonFields/documentType';
import {documentNumberValidation} from './commonFields/documentNumber';
import {citizenshipValidation} from './commonFields/citizenship';
import {bonusCardValidation} from './commonFields/bonusCard';
import {emailValidation} from './contacts/email';
import {phoneValidation} from './contacts/phone';
import {adultBirthdayValidation} from './adultPassenger/adultBirthday';
import {childBirthdayValidation} from './childPassenger/childBirthday';
import {babyBirthdayValidation} from './babyPassenger/babyBirthday';

export const TrainBookForm: IFormValidationInfo = {
    id: 'trainsBookingForm',

    fieldGroups: [
        {
            id: 'adultPassenger',
            fields: [
                lastNameValidation,
                firstNameValidation,
                patronymicValidation,
                sexValidation,
                documentTypeValidation,
                documentNumberValidation,
                citizenshipValidation,
                bonusCardValidation,

                adultBirthdayValidation,
            ],
        },
        {
            id: 'childPassenger',
            fields: [
                lastNameValidation,
                firstNameValidation,
                patronymicValidation,
                sexValidation,
                documentTypeValidation,
                documentNumberValidation,
                citizenshipValidation,
                bonusCardValidation,

                childBirthdayValidation,
            ],
        },
        {
            id: 'babyPassenger',
            fields: [
                lastNameValidation,
                firstNameValidation,
                patronymicValidation,
                sexValidation,
                documentTypeValidation,
                documentNumberValidation,
                citizenshipValidation,
                bonusCardValidation,

                babyBirthdayValidation,
            ],
        },
        {
            id: 'contacts',
            fields: [emailValidation, phoneValidation],
        },
    ],
};
