import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';
import EDocumentType from '../../../../../../common/EDocumentType';

export const babyBirthdayValidation: TField = {
    name: 'adultBirthday',

    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.MIN_DATE_FROM_TODAY,
                params: {
                    offset: 5,
                    scale: 'year',
                },
                errorMessage: 'Не старше 5 лет',
            },
            {
                type: EValidationType.MAX_DATE_FROM_TODAY,
                params: {
                    offset: 0,
                    scale: 'year',
                },
                errorMessage: 'Не младше 0 лет',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_NATIONAL_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.MAX_DATE_FROM_TODAY,
                        params: {
                            offset: 14,
                            scale: 'year',
                        },
                        errorMessage:
                            'Паспорт РФ может быть выдан гражданам старше 14 лет',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_MILITARY_ID],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.MAX_DATE_FROM_FIELD,
                        params: {
                            offset: 18,
                            scale: 'year',
                            field: {
                                fieldGroupId: 'passenger',
                                fieldName: 'startDate',
                            },
                        },
                        errorMessage:
                            'Военный билет может быть выдан гражданам достигшим 18 лет в день отправления поезда',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_SEAMAN_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.MAX_DATE_FROM_FIELD,
                        params: {
                            offset: 14,
                            scale: 'year',
                            field: {
                                fieldGroupId: 'passenger',
                                fieldName: 'startDate',
                            },
                        },
                        errorMessage:
                            'Паспорт моряка может быть выдан гражданам достигшим 14 лет в день отправления поезда',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_BIRTH_CERTIFICATE],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.MAX_DATE_FROM_TODAY,
                        params: {
                            offset: 170,
                            scale: 'month',
                            field: {
                                fieldGroupId: 'passenger',
                                fieldName: 'startDate',
                            },
                        },
                        errorMessage:
                            'Свидетельство о рождении может быть использовано при возрасте до 14 лет и 2 месяцев в день отправления поезда',
                    },
                ],
            },
        },
    ],
};
