import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';
import EDocumentType from '../../../../../../common/EDocumentType';

export const bonusCardValidation: TField = {
    name: 'bonusCard',
    validation: {
        submit: [
            {
                type: EValidationType.REGEX,
                params: 'd{13}',
                errorMessage: 'Бонусная карта - 13 чисел',
            },
        ],
    },
    dependentValidations: [
        {
            /* Для ребенка до 0-10 лет сокращенный набор доков */
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_MILITARY_ID],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.AVAILABLE,
                        params: true,
                        errorMessage:
                            'Бонусная карта не доступна для военного билета',
                    },
                ],
            },
        },
    ],
};
