import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';
import EDocumentType from '../../../../../../common/EDocumentType';

export const citizenshipValidation: TField = {
    name: 'citizenship',
    dependentValidations: [
        {
            /* Для ребенка до 0-10 лет сокращенный набор доков */
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.OTHER],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REQUIRED,
                        params: true,
                        errorMessage: 'Поле должно быть заполнено',
                    },
                ],
            },
        },
    ],
};
