import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';
import EDocumentType from '../../../../../../common/EDocumentType';

export const documentNumberValidation: TField = {
    name: 'documentNumber',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
        ],
    },
    dependentValidations: [
        /* Паспорт РФ */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_NATIONAL_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: '^d{8}(9[789]|[01]d|2[0123])$',
                        errorMessage: '',
                    },
                ],
            },
        },
        /* Загран РФ */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_FOREIGN_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: '^d{9}$',
                        errorMessage: '',
                    },
                ],
            },
        },
        /* Свидетельство о рождении */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_BIRTH_CERTIFICATE],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: '^[IVXivx]+[а-яёА-ЯЁ]{2}d{6}$',
                        errorMessage: '',
                    },
                ],
            },
        },
        /* Военник */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_MILITARY_ID],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: '^[а-яёА-ЯЁ]{2}d{6,7}$',
                        errorMessage: '',
                    },
                ],
            },
        },
        /* Паспорт моряка */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_SEAMAN_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: '^[IVXivx]{2}d{7}$',
                        errorMessage: '',
                    },
                ],
            },
        },
        /* Другой документ */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.OTHER],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.MAX_LENGTH,
                        params: 16,
                        errorMessage: 'Максимальная длинна 16 символов',
                    },
                ],
            },
        },
        /* Другой документ, если только латиница */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.OTHER],
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentNumber',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: '[A-z]',
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.MAX_LENGTH,
                        params: 5,
                        errorMessage:
                            'Минимальная длина 5 символов (только латиница)',
                    },
                ],
            },
        },
    ],
};
