import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';
import EDocumentType from '../../../../../../common/EDocumentType';

export const documentTypeValidation: TField = {
    name: 'documentType',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.ONE_OF,
                params: [
                    EDocumentType.OTHER,
                    EDocumentType.RU_NATIONAL_PASSPORT,
                    EDocumentType.RU_BIRTH_CERTIFICATE,
                    EDocumentType.RU_FOREIGN_PASSPORT,
                    EDocumentType.RU_SEAMAN_PASSPORT,
                    EDocumentType.RU_MILITARY_ID,
                ],
                errorMessage: 'Неверный тип документа',
            },
        ],
    },
    dependentValidations: [
        {
            /* Для ребенка до 0-10 лет сокращенный набор доков */
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'birthday',
                    },
                    value: [
                        {
                            type: EValidationType.MIN_DATE_FROM_TODAY,
                            params: {
                                offset: 10,
                                scale: 'year',
                            },
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.ONE_OF,
                        params: [
                            EDocumentType.OTHER,
                            EDocumentType.RU_BIRTH_CERTIFICATE,
                            EDocumentType.RU_FOREIGN_PASSPORT,
                        ],
                        errorMessage: '',
                    },
                ],
            },
        },
    ],
};
