import {ENG_NAME, NAME_MASK, RUS_NAME} from '../constants';

import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';
import EDocumentType from '../../../../../../common/EDocumentType';

export const firstNameValidation: TField = {
    name: 'firstName',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.MAX_LENGTH,
                params: 20,
                errorMessage: 'Максимальная длина 20 символов',
            },
            {
                type: EValidationType.REGEX,
                params: NAME_MASK,
                errorMessage: 'Имя должно быть на кирилице или латинице',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [
                                EDocumentType.RU_FOREIGN_PASSPORT,
                                EDocumentType.OTHER,
                            ],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${RUS_NAME}$`,
                        errorMessage: 'Имя должно быть на кириллице',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'lastName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${RUS_NAME}$`,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'patronymic',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${RUS_NAME}$`,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${RUS_NAME}$`,
                        errorMessage:
                            'ФИО должны быть на одном языке (кириллица)',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'lastName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${ENG_NAME}$`,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'patronymic',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${ENG_NAME}$`,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${ENG_NAME}$`,
                        errorMessage:
                            'ФИО должны быть на одном языке (латиница)',
                    },
                ],
            },
        },
    ],
};
