import {ENG_NAME, NAME_MASK, RUS_NAME} from '../constants';

import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';

export const lastNameValidation: TField = {
    name: 'lastName',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.MAX_LENGTH,
                params: 40,
                errorMessage: 'Максимальная длина 40 символов',
            },
            {
                type: EValidationType.REGEX,
                params: NAME_MASK,
                errorMessage: 'Фамилия должна быть на кирилице или латинице',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [
                                'international_passport',
                                'foreign_passport',
                            ],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${RUS_NAME}$`,
                        errorMessage:
                            'Фамилия для Российского паспорта должна быть на кириллице',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'firstName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${RUS_NAME}$`,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'patronymic',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${RUS_NAME}$`,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${RUS_NAME}$`,
                        errorMessage:
                            'ФИО должны быть на одном языке (кириллица)',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'firstName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${ENG_NAME}$`,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'patronymic',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${ENG_NAME}$`,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${ENG_NAME}$`,
                        errorMessage:
                            'ФИО должны быть на одном языке (латиница)',
                    },
                ],
            },
        },
    ],
};
