import {DASHES, ENG_NAME, RUS_NAME} from '../constants';

import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';

const RUS_PATRONYMIC = `([${DASHES}]|(${RUS_NAME}))`;
const ENG_PATRONYMIC = `([${DASHES}]|(${ENG_NAME}))`;

export const PATRONYMIC_MASK = `^(${RUS_PATRONYMIC}|${ENG_PATRONYMIC})$`;

export const patronymicValidation: TField = {
    name: 'patronymic',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.MAX_LENGTH,
                params: 20,
                errorMessage: 'Максимальная длина 20 символов',
            },
            {
                type: EValidationType.REGEX,
                params: PATRONYMIC_MASK,
                errorMessage:
                    'Отчество должно быть на кирилице или латинице. Если отсутствует, то дефис',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                    },
                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [
                                'international_passport',
                                'foreign_passport',
                            ],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${RUS_NAME}$`,
                        errorMessage: 'Имя должно быть на кириллице',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'firstName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${RUS_NAME}`,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'lastName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${RUS_NAME}`,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${RUS_NAME}`,
                        errorMessage:
                            'ФИО должны быть на одном языке (кириллица)',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'firstName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${ENG_NAME}`,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'lastName',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: `^${ENG_NAME}`,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: `^${ENG_NAME}`,
                        errorMessage:
                            'ФИО должны быть на одном языке (латиница)',
                    },
                ],
            },
        },
    ],
};
