import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';

export const sexValidation: TField = {
    name: 'sex',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.ONE_OF,
                params: ['male', 'female'],
                errorMessage: 'Третьего не дано',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'patronymic',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: '^.*((ич)|(лы))$',
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.ONE_OF,
                        params: ['male'],
                        errorMessage:
                            'Для отчества на "ич", "лы", пол должен быть мужским',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'patronymic',
                    },
                    value: [
                        {
                            type: EValidationType.REGEX,
                            params: '^.*((на)|(зы))$',
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.ONE_OF,
                        params: ['female'],
                        errorMessage:
                            'Для отчества на "на", "зы", пол должен быть женским',
                    },
                ],
            },
        },
    ],
};
