import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';

export const emailValidation: TField = {
    name: 'email',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.MAX_LENGTH,
                params: 100,
                errorMessage: 'Не длиннее 100 символов',
            },
            {
                type: EValidationType.REGEX,
                params: '^[A-zd.+-]+@[A-zd.+-]+.(ru|com|org|vn)$', // и куча других захардкоженых доменов
                errorMessage: 'Жуткое количество правил',
            },
        ],
    },
};
