import {TField} from '../../../../form';
import {EValidationType} from '../../../../validations';
import EDocumentType from '../../../../../../common/EDocumentType';

export const phoneValidation: TField = {
    name: 'phone',
    validation: {
        submit: [
            {
                type: EValidationType.REQUIRED,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.REGEX,
                params: '(+[d]{6,30})',
                errorMessage: 'Мобилу надо',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: 'documentType',
                        type: 'some',
                    },

                    value: [
                        {
                            type: EValidationType.ONE_OF,
                            params: [EDocumentType.RU_NATIONAL_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.REGEX,
                        params: '((8(d){10})|(+7(d){4,10}))',
                        errorMessage:
                            'Если есть хоть один паспорт РФ, то телефон в РФ формате',
                    },
                ],
            },
        },
    ],
};
