import {IDependentValidation, TValidations} from './validations';

// -------------------------------------------------
// Form
// -------------------------------------------------

export type TFormId = string;

export interface IFormValidationInfo {
    id: TFormId;

    fieldGroups: IFieldGroupValidation[];
}

// -------------------------------------------------
// FieldGroup
// -------------------------------------------------

export type TFieldGroupId = string;

/**
 * @note Контакная информация.
 * @note Документ в ЗКП.
 * @note Документ на форме бронирования.
 * @note Тариф Авиа.
 * @note Параметры поиска Авиабилетов.
 */
export interface IFieldGroupValidation {
    id: TFieldGroupId;
    fields: TField[];
}

// -------------------------------------------------
// Field
// -------------------------------------------------

/** Тип, фиксирующий хотя бы одну из валидаций, как обязательную */
type TFieldValidation =
    | {
          validation: IFieldValidation;
          dependentValidations?: IDependentValidation[];
      }
    | {
          validation?: IFieldValidation;
          dependentValidations: IDependentValidation[];
      };

export type TField = TFieldValidation & {
    name: string;
};

export interface IFieldValidation<
    T extends TValidations = TValidations,
    Y extends TValidations = T,
> {
    blur?: T;
    submit?: Y;
}
