# Yandex.Travel UI-Kit

## Критерии компонента, чтобы быть частью UI-Kit

-   есть на странице [styles в разделе Travel.Styles в фигме](https://www.figma.com/file/I8EBpOVkBHKTHVrDyWuaaIhI/Travel.Styles)
-   абстрактный, не должен знать ничего о конкретном приложении
-   основывается только на пропсах, никаких своих текстов и т.д быть по возможности не должно
-   должен быть универсальный, не знает о контексте его использования
-   никаких сайд-эффектов: не должен внутри использовать роутер и т.д
-   только чистые зависимости (Lego норм, роутер не норм)

## Кодстайл

### Наименование и расположение файлов

#### React компоненты

Компонент и стили для компонента называем по имени папки.

Для добавления примера в `storybook` используем файл `<ComponentName>.stories.(tsx|mdx)`.

```
.
└── Button
    ├── Button.scss
    ├── Button.stories.tsx
    └── Button.tsx
```

Всегда экспортируем компонент именованным экспортом, кроме того обязательно экспортируем тип его пропсов:

```tsx
export interface IButtonProps {}

export const Button: React.FC<IButtonProps> = () => {};
```

Интерфейсы, типы и перечисления должны иметь префикс `YTravelUIKit`, пример для интерфейса `IYTravelUIKit`

Компоненты должны быть функциональные, классовые только в крайних случаях, когда иначе нельзя

#### Вспомогательные функции

Лежат в папках `utilities`. Если предполагается, что функций будет достаточно много, то рекомендуется группировать в подпапки по смыслу.

Общие для всего проекта функции лежат в папке `/src/utilities`.

```
.
└── src
    └── utilities
        └── getNow.ts
```

Сгруппированные по смыслу.

```
.
└── src
    └── utilities
        └── strings
            └── capitalizeFirstLetter.ts
            └── charCodes.ts
            └── humanList.ts
            └── lowercaseFirstLetter.ts
```

Если функция является достаточно специфичной и с большой долей вероятности будет использоваться в рамках какого-то одного компонента, то функция должна лежать рядом с компонентом, она не будет экспортирована наружу для пользователей пакета.

```
.
└── src
    └── components
        └── Button
            └── Button.tsx
            └── utilities
                └── calculateSmth.ts
```

## Гайд по работе с цветами

Все цвета должны быть взяты из дизайнерских гайдов: https://nda.ya.ru/3UZpVa

### Как придумать название для цвета

Название для цвета состоит из следующих частей (порядок важен):

-   [не обязательное] `bg/border` обводка или заливка. Несмотря на то, что эта часть не обязательная, почти у всех контролов она есть. Исключение составляют цвета ссылок и текста.
    -   Пример: есть кнопка, у которой есть обводка и заливка. Цвет обводки будет начинаться с bg, цвет заливки с border
    -   Пример: есть линия-разделитель. Ее цвет начинается с border, у нее нет парного цвета, который начинался бы с bg
-   [обязательное] `control` сущность, для которой применяется цвет (Кнопка, текст, ссылка)
-   [обязательное] `theme` тема. Если предполагается, что тема у контрола одна - используется слово default
-   [необязательное] `состояние` Привычные hover, focused, disabled, etc
-   [обязательное] `color/gradient` Отражает суть значения: цвет это или градиент

### Правила по работе с цветами и тенями:

1. При разработке все цвета должны использоваться из файла `src/styles/colors.scss` и иметь префикс `ytravel-ui-kit`, пример:

```css
:root {
    --ytravel-ui-kit-bg-noop-primary-color: #000;
}
```

2. Писать литералы цветов прямо в css нельзя.

3. Тени описываются в общем файле `src/styles/shadows.scss` и должны соответствовать теням в гайде.

## Разработка и окружение

## Использование
